/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;

@Operation(id="Blob.GetList", category="Files", label="Get Document Files", description="Gets a list of files that are attached on the input document. The files location should be specified using the blob list property xpath. Returns a list of files.")
public class GetDocumentBlobs {
    public static final String ID = "Blob.GetList";
    @Param(name="xpath", required=false, values={"files:files"})
    protected String xpath = "files:files";

    @OperationMethod
    public BlobList run(DocumentModel doc) throws Exception {
        BlobList blobs = new BlobList();
        ListProperty list = (ListProperty)doc.getProperty(this.xpath);
        if (list == null) {
            return blobs;
        }
        for (Property p : list) {
            blobs.add((Blob)p.getValue("file"));
        }
        return blobs;
    }

    @OperationMethod
    public BlobList run(DocumentModelList docs) throws Exception {
        BlobList blobs = new BlobList();
        for (DocumentModel doc : docs) {
            try {
                blobs.addAll(this.run(doc));
            }
            catch (PropertyException e) {}
        }
        return blobs;
    }
}

