/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.CheckOut", category="Document", label="Check Out", description="Checks out the input document. Returns back the document.")
public class CheckOutDocument {
    public static final String ID = "Document.CheckOut";
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentRef run(DocumentRef doc) throws Exception {
        if (!this.session.isCheckedOut(doc)) {
            this.session.checkOut(doc);
        }
        return doc;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (!doc.isCheckedOut()) {
            this.session.checkOut(doc.getRef());
            doc.refresh(1, null);
        }
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.session.getDocument(this.run(doc)));
        }
        return result;
    }
}

