/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.Unlock", category="Document", label="Unlock", description="Unlock the input document. The unlock will be executed in the name of the current user. An user can unlock a document only if has the UNLOCK permission granted on the document or if it the same user as the one that locked the document. Return the unlocked document")
public class UnlockDocument {
    public static final String ID = "Document.Unlock";
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentRef run(DocumentRef doc) throws Exception {
        this.session.unlock(doc);
        return doc;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        doc.unlock();
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.session.getDocument(this.run(doc)));
        }
        return result;
    }
}

