/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.security.Principal;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallbackHandler;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Auth.LoginAs", category="Users & Groups", label="Login As", description="Login As the given user. If no user is given a system login is performed. This is a void operations - the input will be returned back as the output.")
public class LoginAs {
    public static final String ID = "Auth.LoginAs";
    @Context
    protected OperationContext ctx;
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod
    public void run() throws Exception {
        Principal origPrincipal;
        LoginContext lc = null;
        lc = this.name == null ? ((origPrincipal = this.ctx.getPrincipal()) != null ? Framework.loginAs((String)origPrincipal.getName()) : Framework.login()) : LoginAs.loginAs(this.name);
        if (lc != null) {
            this.ctx.getLoginStack().push(lc);
        }
    }

    public static LoginContext loginAs(String username) throws LoginException {
        UserIdentificationInfo userIdent = new UserIdentificationInfo(username, username);
        userIdent.setLoginPluginName("Trusting_LM");
        PluggableAuthenticationService service = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
        UserIdentificationInfoCallbackHandler handler = service.getCallbackHandler(userIdent);
        LoginContext loginContext = new LoginContext("nuxeo-ecm-web", (CallbackHandler)handler);
        loginContext.login();
        return loginContext;
    }
}

