/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.DatabaseMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.nuxeo.ecm.directory.DirectoryException;

public class HibernateDialectHelper {
    protected static Class<?> hibernateFactory;
    protected static Boolean use332API;
    protected static Log log;

    protected static synchronized Class<?> getFactory() {
        if (hibernateFactory == null) {
            try {
                hibernateFactory = Class.forName("org.hibernate.dialect.DialectFactory");
                use332API = false;
            }
            catch (Exception e) {
                try {
                    hibernateFactory = Class.forName("org.hibernate.dialect.resolver.DialectFactory");
                    use332API = true;
                }
                catch (Exception e2) {
                    log.error((Object)"Unable to find hibernate DialectFacory", (Throwable)e);
                }
            }
        }
        return hibernateFactory;
    }

    protected static boolean use332API() {
        if (use332API == null) {
            HibernateDialectHelper.getFactory();
        }
        return use332API;
    }

    public static Dialect buildDialect(String dialectName) throws DirectoryException {
        try {
            if (HibernateDialectHelper.use332API()) {
                return (Dialect)HibernateDialectHelper.getFactory().getMethod("constructDialect", String.class).invoke(null, dialectName);
            }
            return (Dialect)HibernateDialectHelper.getFactory().getMethod("buildDialect", String.class).invoke(null, dialectName);
        }
        catch (Throwable e) {
            throw new DirectoryException("Unable to find method to build dialect", e);
        }
    }

    public static Dialect determineDialect(DatabaseMetaData metadata) throws DirectoryException {
        try {
            if (HibernateDialectHelper.use332API()) {
                Class<?> resolverClass = Class.forName("org.hibernate.dialect.resolver.StandardDialectResolver");
                Object resolver = resolverClass.newInstance();
                return (Dialect)resolverClass.getMethod("resolveDialect", DatabaseMetaData.class).invoke(resolver, metadata);
            }
            String dbname = metadata.getDatabaseProductName();
            int dbmajor = metadata.getDatabaseMajorVersion();
            Class[] partypes = new Class[]{String.class, Integer.TYPE};
            return (Dialect)HibernateDialectHelper.getFactory().getMethod("determineDialect", partypes).invoke(null, dbname, dbmajor);
        }
        catch (Throwable e) {
            throw new DirectoryException("Unable to find method to determine dialect", e);
        }
    }

    static {
        use332API = null;
        log = LogFactory.getLog(HibernateDialectHelper.class);
    }
}

