/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;

@XObject(value="directory")
public class SQLDirectoryDescriptor {
    private static final Log log = LogFactory.getLog(SQLDirectoryDescriptor.class);
    private static final String[] SCRIPT_POLICIES = new String[]{"never", "on_missing_columns", "always"};
    private static final String DEFAULT_POLICY = "never";
    @XNode(value="@name")
    public String name;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="parentDirectory")
    public String parentDirectory;
    @XNode(value="dataSource")
    public String dataSourceName;
    @XNode(value="dialect")
    public String dialectName;
    @XNode(value="dbDriver")
    public String dbDriver;
    @XNode(value="dbUrl")
    public String dbUrl;
    @XNode(value="dbUser")
    public String dbUser;
    @XNode(value="dbPassword")
    public String dbPassword;
    @XNode(value="table")
    public String tableName;
    @XNodeList(value="init-dependencies/dependency", type=ArrayList.class, componentType=String.class)
    public List<String> initDependencies;
    @XNode(value="idField")
    public String idField;
    @XNode(value="dataFile")
    public String dataFileName;
    public String createTablePolicy;
    private SubstringMatchType substringMatchType = SubstringMatchType.subinitial;
    @XNode(value="autoincrementIdField")
    public boolean autoincrementIdField;
    @XNode(value="readOnly")
    public Boolean readOnly = Boolean.FALSE;
    @XNode(value="passwordField")
    private String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNode(value="querySizeLimit")
    private int querySizeLimit;
    @XNodeList(value="references/tableReference", type=TableReference[].class, componentType=TableReference.class)
    private TableReference[] tableReferences;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    private InverseReference[] inverseReferences;
    @XNode(value="@remove")
    private boolean remove = false;
    @XNode(value="cacheTimeout")
    public int cacheTimeout = 0;
    @XNode(value="cacheMaxSize")
    public int cacheMaxSize = 0;
    @XNodeList(value="filters/staticFilter", type=SQLStaticFilter[].class, componentType=SQLStaticFilter.class)
    private SQLStaticFilter[] staticFilters;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getCreateTablePolicy() {
        return this.createTablePolicy;
    }

    @XNode(value="createTablePolicy")
    public void setCreateTablePolicy(String createTablePolicy) throws DirectoryException {
        if (createTablePolicy == null) {
            this.createTablePolicy = DEFAULT_POLICY;
            return;
        }
        createTablePolicy = createTablePolicy.toLowerCase();
        boolean validPolicy = false;
        for (String policy : SCRIPT_POLICIES) {
            if (!createTablePolicy.equals(policy)) continue;
            validPolicy = true;
            break;
        }
        if (!validPolicy) {
            throw new DirectoryException("invalid value for createTablePolicy: " + createTablePolicy + ". It should be one of 'never', " + "'on_missing_columns',  or 'always'.");
        }
        this.createTablePolicy = createTablePolicy;
    }

    @XNode(value="substringMatchType")
    public void setSubstringMatchType(String substringMatchType) {
        if (substringMatchType != null) {
            try {
                this.substringMatchType = Enum.valueOf(SubstringMatchType.class, substringMatchType);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Invalid substring match type: " + substringMatchType + ". Valid options: subinitial, subfinal, subany"));
                this.substringMatchType = SubstringMatchType.subinitial;
            }
        }
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getTableReferences() {
        return this.tableReferences;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAutoincrementIdField() {
        return this.autoincrementIdField;
    }

    public void setAutoincrementIdField(boolean autoincrementIdField) {
        this.autoincrementIdField = autoincrementIdField;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setInverseReferences(InverseReference[] inverseReferences) {
        this.inverseReferences = inverseReferences;
    }

    public void setDataFileName(String dataFile) {
        this.dataFileName = dataFile;
    }

    public void setTableReferences(TableReference[] tableReferences) {
        this.tableReferences = tableReferences;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public void setRemove(boolean delete) {
        this.remove = delete;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public SubstringMatchType getSubstringMatchType() {
        return this.substringMatchType;
    }

    public void setSubstringMatchType(SubstringMatchType substringMatchType) {
        this.substringMatchType = substringMatchType;
    }

    public SQLStaticFilter[] getStaticFilters() {
        if (this.staticFilters == null) {
            return new SQLStaticFilter[0];
        }
        return this.staticFilters;
    }

    public static enum SubstringMatchType {
        subinitial,
        subfinal,
        subany;

    }
}

