/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryProxy;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class SQLDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.directory.sql.SQLDirectoryFactory");
    private static final Log log = LogFactory.getLog(SQLDirectoryFactory.class);
    private Map<String, Directory> proxies;

    public Directory getDirectory(String name) throws DirectoryException {
        return this.proxies.get(name);
    }

    public String getName() {
        return NAME.getName();
    }

    public void activate(ComponentContext context) {
        this.proxies = new HashMap<String, Directory>();
    }

    public void deactivate(ComponentContext context) {
        this.proxies = null;
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getRuntime().getComponent(DirectoryService.NAME);
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = SQLDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            String descriptorName = descriptor.getName();
            if (descriptor.getRemove()) {
                log.info((Object)("Removing directory: " + descriptorName));
                this.proxies.remove(descriptorName);
                dirService.unregisterDirectory(descriptorName, (DirectoryFactory)this);
                continue;
            }
            if (this.proxies.containsKey(descriptorName)) {
                this.mergeDescriptor(descriptor);
            }
            this.proxies.put(descriptorName, new SQLDirectoryProxy(descriptor));
            dirService.registerDirectory(descriptorName, (DirectoryFactory)this);
            log.info((Object)("Registered directory: " + descriptorName));
        }
    }

    private void mergeDescriptor(SQLDirectoryDescriptor descriptor) {
        SQLDirectoryDescriptor oldDescriptor = ((SQLDirectoryProxy)this.proxies.get(descriptor.getName())).getDescriptor();
        if (descriptor.getDbUser() == null) {
            descriptor.setDbUser(oldDescriptor.getDbUser());
        }
        if (descriptor.getDbPassword() == null) {
            descriptor.setDbPassword(oldDescriptor.getDbPassword());
        }
        if (descriptor.getDataSourceName() == null) {
            descriptor.setDataSourceName(oldDescriptor.getDataSourceName());
        }
        if (descriptor.getDbDriver() == null) {
            descriptor.setDbDriver(oldDescriptor.getDbDriver());
        }
        if (descriptor.getDbUrl() == null) {
            descriptor.setDbUrl(oldDescriptor.getDbUrl());
        }
        if (descriptor.getCreateTablePolicy() == null) {
            try {
                descriptor.setCreateTablePolicy(oldDescriptor.getCreateTablePolicy());
            }
            catch (DirectoryException e) {
                log.error((Object)e);
            }
        }
        if (descriptor.getIdField() == null) {
            descriptor.setIdField(oldDescriptor.getIdField());
        }
        if (descriptor.getReadOnly() == null) {
            descriptor.setReadOnly(oldDescriptor.getReadOnly());
        }
        if (descriptor.getSchemaName() == null) {
            descriptor.setSchemaName(oldDescriptor.getSchemaName());
        }
        if (descriptor.getParentDirectory() == null) {
            descriptor.setParentDirectory(oldDescriptor.getParentDirectory());
        }
        if (descriptor.getDataFileName() == null) {
            descriptor.setDataFileName(oldDescriptor.getDataFileName());
        }
        if (descriptor.getTableName() == null) {
            descriptor.setTableName(oldDescriptor.getTableName());
        }
        if (descriptor.getInverseReferences() == null || descriptor.getInverseReferences().length == 0) {
            descriptor.setInverseReferences((InverseReference[])oldDescriptor.getInverseReferences());
        }
        if (descriptor.getTableReferences() == null || descriptor.getTableReferences().length == 0) {
            descriptor.setTableReferences((TableReference[])oldDescriptor.getTableReferences());
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = SQLDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            String directoryName = descriptor.getName();
            dirService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            Directory directory = this.proxies.remove(directoryName);
            if (directory == null) continue;
            directory.shutdown();
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.proxies.values()) {
            directory.shutdown();
        }
    }

    public List<Directory> getDirectories() throws DirectoryException {
        ArrayList<Directory> directoryList = new ArrayList<Directory>();
        directoryList.addAll(this.proxies.values());
        return directoryList;
    }
}

