/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.contribs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.DocSpaceImpl;

public class RootDocSpaceProvider
extends AbstractSpaceProvider {
    private static final Log log = LogFactory.getLog(RootDocSpaceProvider.class);
    private final DocumentModel rootDoc;

    public RootDocSpaceProvider(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    public void add(Space o, CoreSession session) throws SpaceException {
        try {
            DocSpaceImpl space = DocSpaceImpl.createFromSpace(o, this.rootDoc.getPathAsString(), session);
            session.saveDocument(space.getDocument());
            session.save();
        }
        catch (ClientException e) {
            throw new SpaceException((Throwable)e);
        }
    }

    public void addAll(Collection<? extends Space> c, CoreSession session) throws SpaceException {
        try {
            for (Space space : c) {
                this.add(space, session);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void clear(CoreSession session) throws SpaceException {
        try {
            session.removeChildren(this.rootDoc.getRef());
        }
        catch (ClientException e) {
            throw new SpaceException("Unable to complete clear", (Throwable)e);
        }
    }

    public Space doGetSpace(String spaceName, CoreSession session) throws SpaceException {
        DocumentModel doc;
        try {
            doc = session.getChild(this.rootDoc.getRef(), spaceName);
        }
        catch (ClientException e) {
            throw new SpaceNotFoundException((Throwable)e);
        }
        return (Space)doc.getAdapter(Space.class);
    }

    public boolean isEmpty(CoreSession session) throws SpaceException {
        return this.size(session) == 0L;
    }

    public boolean remove(Space space, CoreSession session) throws SpaceException {
        PathRef spaceRef = new PathRef(this.rootDoc.getPathAsString() + "/" + space.getName());
        try {
            if (session.exists((DocumentRef)spaceRef)) {
                session.removeDocument((DocumentRef)spaceRef);
                return true;
            }
            return false;
        }
        catch (ClientException e) {
            throw new SpaceNotFoundException((Throwable)e);
        }
    }

    public long size(CoreSession session) throws SpaceException {
        try {
            return session.getChildrenIterator(this.rootDoc.getRef()).size();
        }
        catch (ClientException e) {
            throw new SpaceException((Throwable)e);
        }
    }

    public List<Space> getAll(CoreSession session) throws SpaceException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        try {
            for (DocumentModel doc : session.getChildren(this.rootDoc.getRef())) {
                Space space = (Space)doc.getAdapter(Space.class);
                if (space == null) continue;
                spaces.add(space);
            }
        }
        catch (ClientException e) {
            throw new SpaceException("Unable to query childrens", (Throwable)e);
        }
        return spaces;
    }

    public boolean isReadOnly(CoreSession session) {
        return false;
    }
}

