/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.contribs.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;

public class SingleDocSpaceProvider
extends AbstractSpaceProvider {
    private static final String PARAM_PATH = "path";
    private String path;
    private String title;

    public void initialize(Map<String, String> params) throws Exception {
        if (!params.containsKey(PARAM_PATH)) {
            throw new Exception("No path argument found for SingleDocSpaceProvider");
        }
        this.path = params.get(PARAM_PATH);
        this.title = params.get("title");
        if (null == this.title) {
            this.title = SingleDocSpaceProvider.getDocName(this.path);
        }
    }

    public long size(CoreSession session) {
        return 1L;
    }

    public boolean isReadOnly(CoreSession session) {
        return true;
    }

    public List<Space> getAll(CoreSession session) throws SpaceException {
        ArrayList<Space> result = new ArrayList<Space>();
        result.add(this.getSpace("", session));
        return result;
    }

    public Space doGetSpace(String spaceName, CoreSession session) throws SpaceException {
        return (Space)this.getOrCreateSingleSpace(session).getAdapter(Space.class);
    }

    public boolean isEmpty(CoreSession session) {
        return false;
    }

    private DocumentModel getOrCreateSingleSpace(CoreSession session) throws SpaceException {
        PathRef docRef = new PathRef(this.path);
        try {
            if (session.exists((DocumentRef)docRef)) {
                return session.getDocument((DocumentRef)docRef);
            }
            if (!session.exists((DocumentRef)new PathRef(SingleDocSpaceProvider.getParentPath(this.path)))) {
                throw new ClientException("Parent path does not exist : unable to get or create space");
            }
            UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    DocumentModel doc = this.session.createDocumentModel(SingleDocSpaceProvider.getParentPath(SingleDocSpaceProvider.this.path), SingleDocSpaceProvider.getDocName(SingleDocSpaceProvider.this.path), "Space");
                    doc.setPropertyValue("dc:title", (Serializable)((Object)SingleDocSpaceProvider.this.title));
                    doc = this.session.createDocument(doc);
                    this.session.save();
                }
            };
            runner.runUnrestricted();
            return session.getDocument((DocumentRef)docRef);
        }
        catch (ClientException e) {
            throw new SpaceNotFoundException((Throwable)e);
        }
    }

    static String getParentPath(String fullPath) {
        int firstCharOfDocName = fullPath.lastIndexOf("/");
        if (firstCharOfDocName == -1) {
            return fullPath;
        }
        if (firstCharOfDocName > 0) {
            return fullPath.substring(0, firstCharOfDocName);
        }
        return "/";
    }

    static String getDocName(String fullPath) {
        int firstCharOfDocName = fullPath.lastIndexOf("/");
        if (firstCharOfDocName == -1) {
            return "";
        }
        return fullPath.substring(firstCharOfDocName + 1);
    }
}

