/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSimon
implements Simon {
    protected Manager manager;
    protected boolean enabled;
    protected long firstUsage;
    protected long lastUsage;
    private final String name;
    private SimonState state = SimonState.INHERIT;
    private Simon parent;
    private final List<Simon> children = new CopyOnWriteArrayList<Simon>();
    private String note;
    private long resetTimestamp;
    private Map<String, Object> attributes;

    AbstractSimon(String name, Manager manager) {
        this.name = name;
        this.manager = manager;
        if (name == null || name.equals("")) {
            this.state = SimonState.ENABLED;
            this.enabled = true;
        }
    }

    @Override
    public final Simon getParent() {
        return this.parent;
    }

    @Override
    public final List<Simon> getChildren() {
        return this.children;
    }

    final void setParent(Simon parent) {
        this.parent = parent;
    }

    final void addChild(AbstractSimon simon) {
        this.children.add(simon);
        simon.setParent(this);
        simon.enabled = this.enabled;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setState(SimonState state, boolean overrule) {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isAnonymousOrRootSimon() || !state.equals((Object)SimonState.INHERIT)) {
            this.state = state;
            this.updateAndPropagateEffectiveState(this.shouldBeEffectivlyEnabled(), overrule);
        }
    }

    private boolean isAnonymousOrRootSimon() {
        return this.name == null || this.name.equals("");
    }

    private boolean shouldBeEffectivlyEnabled() {
        if (this.state.equals((Object)SimonState.INHERIT)) {
            return this.parent.isEnabled();
        }
        return this.state.equals((Object)SimonState.ENABLED);
    }

    private void updateAndPropagateEffectiveState(boolean enabled, boolean overrule) {
        this.enabled = enabled;
        for (Simon child : this.children) {
            if (overrule) {
                ((AbstractSimon)child).state = SimonState.INHERIT;
            }
            if (!child.getState().equals((Object)SimonState.INHERIT)) continue;
            ((AbstractSimon)child).updateAndPropagateEffectiveState(enabled, overrule);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void saveResetTimestamp() {
        this.resetTimestamp = System.currentTimeMillis();
    }

    @Override
    public long getLastReset() {
        return this.resetTimestamp;
    }

    @Override
    public final SimonState getState() {
        return this.state;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public long getFirstUsage() {
        return this.firstUsage;
    }

    @Override
    public long getLastUsage() {
        return this.lastUsage;
    }

    public String toString() {
        return "[" + this.name + " " + (Object)((Object)this.state) + "]";
    }

    protected void updateUsages() {
        this.lastUsage = System.currentTimeMillis();
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    void replaceChild(Simon simon, AbstractSimon newSimon) {
        this.children.remove(simon);
        if (newSimon != null) {
            this.children.add(newSimon);
            newSimon.setParent(this);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptySet().iterator();
        }
        return this.attributes.keySet().iterator();
    }
}

