/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.storage.AdministrativeStatusPersister;
import org.nuxeo.ecm.core.management.storage.DocumentStoreManager;
import org.nuxeo.ecm.core.management.storage.DocumentStoreSessionRunner;

public class DocumentModelStatusPersister
implements AdministrativeStatusPersister {
    public static final String ADMINISTRATIVE_INFO_CONTAINER = "administrative-infos";
    public static final String ADMINISTRATIVE_INFO_CONTAINER_DOCUMENT_TYPE = "AdministrativeStatusContainer";
    public static final String ADMINISTRATIVE_STATUS_DOCUMENT_TYPE = "AdministrativeStatus";
    public static final String STATUS_PROPERTY = "status:administrative_status";
    public static final String MESSAGE_PROPERTY = "status:statusMessage";
    public static final String INSTANCE_PROPERTY = "status:instanceId";
    public static final String SERVICE_PROPERTY = "status:serviceId";
    public static final String LOGIN_PROPERTY = "status:userLogin";
    private static final Log log = LogFactory.getLog(DocumentModelStatusPersister.class);

    protected String getAdministrativeStatusDocName(AdministrativeStatus status) {
        return status.getInstanceIdentifier() + "--" + status.getServiceIdentifier();
    }

    @Override
    public List<String> getAllInstanceIds() {
        StatusFetcher fetcher = new StatusFetcher(null, null);
        try {
            fetcher.runUnrestricted();
            return fetcher.allInstanceIds;
        }
        catch (ClientException e) {
            log.error((Object)"Error while fetching all instance Ids", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<AdministrativeStatus> getAllStatuses(String instanceId) {
        StatusFetcher fetcher = new StatusFetcher(instanceId, null);
        try {
            fetcher.runUnrestricted();
            return fetcher.statuses;
        }
        catch (ClientException e) {
            log.error((Object)("Error while fetching all service status for instance " + instanceId), (Throwable)e);
            return null;
        }
    }

    @Override
    public AdministrativeStatus getStatus(String instanceId, String serviceIdentifier) {
        StatusFetcher fetcher = new StatusFetcher(instanceId, serviceIdentifier);
        try {
            fetcher.runUnrestricted();
            if (fetcher.statuses.size() == 1) {
                return fetcher.statuses.get(0);
            }
            log.warn((Object)("Unable to fetch status for service " + serviceIdentifier + " in instance " + instanceId));
            return null;
        }
        catch (ClientException e) {
            log.error((Object)("Error while fetching all service status for instance " + instanceId), (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove(String instanceId) {
        throw new UnsupportedOperationException("Not implemented for now");
    }

    @Override
    public AdministrativeStatus saveStatus(AdministrativeStatus status) {
        try {
            StatusSaver saver = new StatusSaver(status);
            saver.runUnrestricted();
            return saver.getStatus();
        }
        catch (Exception e) {
            log.error((Object)"Error while saving status", (Throwable)e);
            return null;
        }
    }

    public class StatusFetcher
    extends DocumentStoreSessionRunner {
        protected String instanceId;
        protected String serviceId;
        protected List<String> allInstanceIds = new ArrayList<String>();
        protected List<AdministrativeStatus> statuses = new ArrayList<AdministrativeStatus>();

        public StatusFetcher(String instanceId, String serviceId) {
            this.instanceId = instanceId;
            this.serviceId = serviceId;
        }

        @Override
        protected String errorMessage() {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot fetch statuses ");
            if (this.instanceId != null) {
                sb.append(" for ").append(this.instanceId);
            }
            if (this.serviceId != null) {
                sb.append(":").append(this.serviceId);
            }
            return sb.toString();
        }

        public void run() throws ClientException {
            boolean onlyFetchIds = false;
            StringBuffer sb = new StringBuffer("select * from ");
            sb.append(DocumentModelStatusPersister.ADMINISTRATIVE_STATUS_DOCUMENT_TYPE);
            if (this.instanceId == null) {
                onlyFetchIds = true;
            } else {
                sb.append(" where ");
                sb.append(DocumentModelStatusPersister.INSTANCE_PROPERTY);
                sb.append("='");
                sb.append(this.instanceId);
                sb.append("'");
                if (this.serviceId != null) {
                    sb.append(" AND ");
                    sb.append(DocumentModelStatusPersister.SERVICE_PROPERTY);
                    sb.append("='");
                    sb.append(this.serviceId);
                    sb.append("'");
                }
            }
            DocumentModelList result = this.session.query(sb.toString());
            for (DocumentModel doc : result) {
                if (onlyFetchIds) {
                    String id = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.INSTANCE_PROPERTY));
                    if (this.allInstanceIds.contains(id)) continue;
                    this.allInstanceIds.add(id);
                    continue;
                }
                this.statuses.add(this.wrap(doc));
            }
        }

        protected AdministrativeStatus wrap(DocumentModel doc) throws ClientException {
            String userLogin = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.LOGIN_PROPERTY));
            String id = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.INSTANCE_PROPERTY));
            String service = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.SERVICE_PROPERTY));
            String message = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.MESSAGE_PROPERTY));
            String state = (String)((Object)doc.getPropertyValue(DocumentModelStatusPersister.STATUS_PROPERTY));
            Calendar modified = (Calendar)doc.getPropertyValue("dc:modified");
            AdministrativeStatus status = new AdministrativeStatus(state, message, modified, userLogin, id, service);
            return status;
        }
    }

    private class StatusSaver
    extends DocumentStoreSessionRunner {
        protected AdministrativeStatus status;

        public StatusSaver(AdministrativeStatus status) {
            this.status = status;
        }

        @Override
        protected String errorMessage() {
            return "Cannot save  " + this.status;
        }

        public void run() throws ClientException {
            this.doGetOrCreateDoc(this.status);
            this.session.save();
        }

        public AdministrativeStatus getStatus() {
            return this.status;
        }

        protected DocumentModel doGetOrCreateContainer() throws ClientException {
            PathRef admRootDocRef = DocumentStoreManager.newPath(DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER);
            if (!this.session.exists((DocumentRef)admRootDocRef)) {
                DocumentModel doc = this.session.createDocumentModel(DocumentStoreManager.newPath(new String[0]).toString(), DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER, DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER_DOCUMENT_TYPE);
                doc.setPropertyValue("dc:title", (Serializable)((Object)DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER));
                doc = this.session.createDocument(doc);
                this.session.save();
            }
            return this.session.getDocument((DocumentRef)admRootDocRef);
        }

        protected DocumentModel doGetOrCreateDoc(AdministrativeStatus status) throws ClientException {
            DocumentModel administrativeContainer = this.doGetOrCreateContainer();
            PathRef statusDocRef = new PathRef(administrativeContainer.getPathAsString() + "/" + DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status));
            DocumentModel doc = null;
            boolean create = false;
            if (!this.session.exists((DocumentRef)statusDocRef)) {
                create = true;
                doc = this.session.createDocumentModel(administrativeContainer.getPathAsString(), DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status), DocumentModelStatusPersister.ADMINISTRATIVE_STATUS_DOCUMENT_TYPE);
            } else {
                doc = this.session.getDocument((DocumentRef)statusDocRef);
            }
            doc.setPropertyValue(DocumentModelStatusPersister.LOGIN_PROPERTY, (Serializable)((Object)status.getUserLogin()));
            doc.setPropertyValue(DocumentModelStatusPersister.INSTANCE_PROPERTY, (Serializable)((Object)status.getInstanceIdentifier()));
            doc.setPropertyValue(DocumentModelStatusPersister.SERVICE_PROPERTY, (Serializable)((Object)status.getServiceIdentifier()));
            doc.setPropertyValue(DocumentModelStatusPersister.MESSAGE_PROPERTY, (Serializable)((Object)status.getMessage()));
            doc.setPropertyValue(DocumentModelStatusPersister.STATUS_PROPERTY, (Serializable)((Object)status.getState()));
            doc.setPropertyValue("dc:title", (Serializable)((Object)DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status)));
            doc = create ? this.session.createDocument(doc) : this.session.saveDocument(doc);
            this.session.save();
            return doc;
        }
    }
}

