/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.server;

import com.google.caja.demos.playground.client.CajolingServiceResult;
import com.google.caja.demos.playground.client.PlaygroundService;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriEffect;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.HtmlSnippetProducer;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Lists;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class GWTCajolingServiceImpl
extends RemoteServiceServlet
implements PlaygroundService {
    private final UriFetcher fetcher;
    private static final UriPolicy uriPolicy = new UriPolicy(){

        @Override
        public String rewriteUri(ExternalReference u, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
            if (effect == UriEffect.NEW_DOCUMENT || effect == UriEffect.SAME_DOCUMENT && loader == LoaderType.SANDBOXED) {
                return u.getUri().toString();
            }
            return "http://caja.appspot.com/cajole?url=" + UriUtil.encode(u.getUri().toString()) + "&loader=" + (Object)((Object)loader) + "&effect=" + (Object)((Object)effect);
        }
    };

    public GWTCajolingServiceImpl(UriFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @ParseTreeNode.ReflectiveCtor
    public GWTCajolingServiceImpl() {
        this(new UriFetcher(){

            @Override
            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                try {
                    return FetchedData.fromConnection(ref.getUri().toURL().openConnection());
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
            }
        });
    }

    private static URI guessURI(String guess) {
        try {
            guess = UriUtil.normalizeUri(guess);
            if (guess != null) {
                return new URI(guess);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return URI.create("unknown:///unknown");
    }

    public String[] getMessageLevels() {
        MessageLevel[] values = MessageLevel.values();
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].name();
        }
        return result;
    }

    @Override
    public CajolingServiceResult cajole(String url, String input, boolean es53Mode) {
        String htmlOut;
        MessageContext mc = new MessageContext();
        SimpleMessageQueue mq = new SimpleMessageQueue();
        Map<InputSource, String> originalSources = Collections.singletonMap(new InputSource(GWTCajolingServiceImpl.guessURI(url)), input);
        PluginMeta meta = new PluginMeta(this.fetcher, uriPolicy);
        meta.setEnableES53(es53Mode);
        PluginCompiler compiler = this.makePluginCompiler(meta, mq);
        compiler.setMessageContext(mc);
        URI uri = GWTCajolingServiceImpl.guessURI(url);
        InputSource is = new InputSource(uri);
        CharProducer cp = CharProducer.Factory.fromString((CharSequence)input, is);
        boolean okToContinue = true;
        Dom inputNode = null;
        try {
            DomParser p = new DomParser(new HtmlLexer(cp), false, is, (MessageQueue)mq);
            inputNode = new Dom(p.parseFragment());
            p.getTokenQueue().expectEmpty();
        }
        catch (ParseException e) {
            mq.addMessage(e.getCajaMessage());
            okToContinue = false;
        }
        if (okToContinue && inputNode != null) {
            compiler.addInput(inputNode, uri);
            okToContinue &= compiler.run();
        }
        CajoledModule outputJs = okToContinue ? compiler.getJavascript() : null;
        Node outputHtml = okToContinue ? compiler.getStaticHtml() : null;
        String[] messages = this.formatMessages(originalSources, mc, mq);
        StringBuilder jsOut = new StringBuilder();
        JsPrettyPrinter renderer = new JsPrettyPrinter(new Concatenator(jsOut));
        RenderContext rc = new RenderContext(renderer).withAsciiOnly(true).withEmbeddable(true);
        String string = htmlOut = outputHtml != null ? Nodes.render(outputHtml) : null;
        if (outputJs != null) {
            outputJs.render(rc);
            rc.getOut().noMoreTokens();
            return new CajolingServiceResult(htmlOut, jsOut.toString(), messages);
        }
        return new CajolingServiceResult(htmlOut, null, messages);
    }

    private String[] formatMessages(Map<InputSource, ? extends CharSequence> inputMap, MessageContext mc, MessageQueue mq) {
        List<Message> messages = mq.getMessages();
        HtmlSnippetProducer sp = new HtmlSnippetProducer(inputMap, mc);
        List<String> result = Lists.newArrayList();
        for (Message msg : messages) {
            String snippet = sp.getSnippet(msg);
            StringBuilder messageText = new StringBuilder();
            messageText.append(msg.getMessageLevel().name()).append(" ").append(msg.format(mc));
            messageText.append(":").append(snippet);
            result.add(messageText.toString());
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getBuildInfo() {
        return BuildInfo.getInstance().getBuildInfo();
    }

    protected PluginCompiler makePluginCompiler(PluginMeta meta, MessageQueue mq) {
        PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), meta, mq);
        return compiler;
    }

    @Override
    public String fetch(String uri) {
        try {
            URI address = new URI(uri);
            return this.fetcher.fetch(new ExternalReference(address, FilePosition.UNKNOWN), "*/*").getTextualContent().toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        catch (UriFetcher.UriFetchException ex) {
            return null;
        }
    }
}

