/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.AttributeNameFixup;
import com.google.caja.parser.html.Html5ElementStack;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Lists;
import java.util.List;
import junit.framework.TestCase;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class Html5ElementStackTest
extends TestCase {
    DOMImplementation domImpl;

    public void setUp() throws Exception {
        super.setUp();
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        this.domImpl = registry.getDOMImplementation("XML 1.0 Traversal 2.0");
    }

    private AttrStub createAttrStub(String name, String value) {
        Token<HtmlTokenType> nameToken = Token.instance(name, HtmlTokenType.ATTRNAME, FilePosition.UNKNOWN);
        Token<HtmlTokenType> valueToken = Token.instance(value, HtmlTokenType.ATTRVALUE, FilePosition.UNKNOWN);
        return new AttrStub(nameToken, valueToken, value);
    }

    public final void testProcessTag() {
        String qname = "html";
        String systemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
        String publicId = "-//W3C//DTD XHTML 1.0 Transitional//EN";
        DocumentType documentType = this.domImpl.createDocumentType(qname, publicId, systemId);
        Document doc = this.domImpl.createDocument(null, null, documentType);
        SimpleMessageQueue mq = new SimpleMessageQueue();
        Html5ElementStack stack = new Html5ElementStack(doc, false, mq);
        stack.open(false);
        Token<HtmlTokenType> start = Token.instance("<helloTag", HtmlTokenType.TAGBEGIN, FilePosition.UNKNOWN);
        Token<HtmlTokenType> end = Token.instance(">", HtmlTokenType.ATTRVALUE, FilePosition.UNKNOWN);
        List<AttrStub> list = Lists.newArrayList(this.createAttrStub("hi~", "hello~"), this.createAttrStub("data:hi~", "hello~"), this.createAttrStub("xmlns:hi~", "hello~"), this.createAttrStub("xmlns:", "hello~"), this.createAttrStub("data:", "hello~"), this.createAttrStub("xmlns", "http://xmlns/index.html"), this.createAttrStub("attr1", "value1"), this.createAttrStub("data:attr", "value2"), this.createAttrStub("xmlns:buffalo", "value3"));
        stack.processTag(start, end, list);
        Html5ElementStackTest.assertEquals((int)4, (int)mq.getMessages().size());
        String TEST_NAME = "unknown:///unknown:0+0";
        Html5ElementStackTest.assertEquals((String)"unknown:///unknown:0+0: ignoring token 'hi~'", (String)mq.getMessages().get(0).toString());
        Html5ElementStackTest.assertEquals((String)"unknown:///unknown:0+0: ignoring token 'data:hi~'", (String)mq.getMessages().get(1).toString());
        Html5ElementStackTest.assertEquals((String)"unknown:///unknown:0+0: ignoring token 'xmlns:hi~'", (String)mq.getMessages().get(2).toString());
        Html5ElementStackTest.assertEquals((String)"unknown:///unknown:0+0: cannot override default XML namespace in HTML", (String)mq.getMessages().get(3).toString());
        Element e = (Element)stack.builderRootElement().getElementsByTagName("hellotag").item(0);
        Html5ElementStackTest.assertEquals((int)5, (int)e.getAttributes().getLength());
        Html5ElementStackTest.assertEquals((String)"value1", (String)e.getAttribute("attr1"));
        Html5ElementStackTest.assertEquals((String)"hello~", (String)e.getAttribute(AttributeNameFixup.fixupNameFromQname("data:")));
        Html5ElementStackTest.assertEquals((String)"hello~", (String)e.getAttribute(AttributeNameFixup.fixupNameFromQname("xmlns:")));
        Html5ElementStackTest.assertEquals((String)"value2", (String)e.getAttribute(AttributeNameFixup.fixupNameFromQname("data:attr")));
        Html5ElementStackTest.assertEquals((String)"value3", (String)e.getAttribute(AttributeNameFixup.fixupNameFromQname("xmlns:buffalo")));
    }
}

