/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlEntities;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Renderer;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.RenderContext;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nodes {
    private static final String FP_KEY = "caja:filePosition";
    private static final String RAW_TEXT_KEY = "caja:rawHtml";
    private static final FilePosition UNKNOWN_START_OF_FILE = FilePosition.startOfFile(InputSource.UNKNOWN);

    public static Iterable<? extends Node> childrenOf(final Node n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    Node child;
                    {
                        this.child = n.getFirstChild();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.child != null;
                    }

                    @Override
                    public Node next() {
                        if (this.child == null) {
                            throw new NoSuchElementException();
                        }
                        Node result = this.child;
                        this.child = this.child.getNextSibling();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<? extends Attr> attributesOf(final Element el) {
        return new Iterable<Attr>(){

            @Override
            public Iterator<Attr> iterator() {
                return new Iterator<Attr>(){
                    NamedNodeMap attrs;
                    int i;
                    int n;
                    {
                        this.attrs = el.getAttributes();
                        this.i = 0;
                        this.n = this.attrs != null ? this.attrs.getLength() : 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.n;
                    }

                    @Override
                    public Attr next() {
                        if (this.i == this.n) {
                            throw new NoSuchElementException();
                        }
                        return (Attr)this.attrs.item(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T extends Node> Iterable<T> nodeListIterable(final NodeList nl, final Class<? extends T> outType) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;
                    int n;
                    {
                        this.n = nl != null ? Integer.valueOf(nl.getLength()) : null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.n;
                    }

                    @Override
                    public T next() {
                        if (this.i == this.n) {
                            throw new NoSuchElementException();
                        }
                        return (Node)outType.cast(nl.item(this.i++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static FilePosition getFilePositionFor(Node node) {
        FilePosition pos = (FilePosition)node.getUserData(FP_KEY);
        if (pos != null) {
            return pos;
        }
        return UNKNOWN_START_OF_FILE;
    }

    public static FilePosition getFilePositionForValue(Attr a) {
        return Nodes.getFilePositionFor(a.getFirstChild());
    }

    public static void setFilePositionFor(Node node, FilePosition pos) {
        node.setUserData(FP_KEY, pos, null);
    }

    public static void setFilePositionForValue(Attr a, FilePosition pos) {
        Nodes.setFilePositionFor(a.getFirstChild(), pos);
    }

    public static void setRawValue(Attr a, String html) {
        Nodes.setRawText((Text)a.getFirstChild(), html);
    }

    public static String getRawValue(Attr a) {
        return Nodes.getRawText((Text)a.getFirstChild());
    }

    public static void setRawText(Text cd, String html) {
        cd.setUserData(RAW_TEXT_KEY, html, null);
    }

    public static String getRawText(Text cd) {
        return (String)cd.getUserData(RAW_TEXT_KEY);
    }

    public static String decode(String html) {
        if (html.indexOf(38) < 0) {
            return html;
        }
        char[] chars = html.toCharArray();
        int delta = 0;
        int n = chars.length;
        int i = 0;
        while (i < n) {
            char ch = chars[i];
            if (chars[i] == '&') {
                long packedEndAndCodepoint = HtmlEntities.decodeEntityAt(chars, i, n);
                int end = (int)(packedEndAndCodepoint >>> 32);
                if (end != i + 1) {
                    int codepoint = (int)packedEndAndCodepoint & 0xFFFFFF;
                    delta += end - (i + Character.toChars(codepoint, chars, i - delta));
                    i = end;
                    continue;
                }
                chars[i - delta] = ch;
                ++i;
                continue;
            }
            chars[i - delta] = ch;
            ++i;
        }
        if (delta == 0) {
            return html;
        }
        return String.valueOf(chars, 0, n - delta);
    }

    public static String encode(String raw) {
        StringBuilder sb = new StringBuilder(raw.length() * 3 / 2);
        Escaping.escapeXml((CharSequence)raw, false, sb);
        return sb.toString();
    }

    public static void render(Node node, Namespaces ns, RenderContext rc) {
        StringBuilder sb = new StringBuilder(262144);
        new Renderer(sb, rc.markupRenderMode(), rc.isAsciiOnly()).render(node, ns);
        TokenConsumer out = rc.getOut();
        FilePosition pos = Nodes.getFilePositionFor(node);
        out.mark(FilePosition.startOf(pos));
        out.consume(sb.toString());
        out.mark(FilePosition.endOf(pos));
    }

    public static void render(Node node, RenderContext rc) {
        Nodes.render(node, Namespaces.HTML_DEFAULT, rc);
    }

    public static String render(Node node) {
        return Nodes.render(node, false);
    }

    @Deprecated
    public static String render(Node node, boolean asXml) {
        return Nodes.render(node, asXml ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
    }

    public static String render(Node node, MarkupRenderMode renderMode) {
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(sb, null)).withMarkupRenderMode(renderMode);
        Nodes.render(node, rc);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }

    private Nodes() {
    }
}

