/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.Elision;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayConstructor
extends AbstractExpression {
    @ParseTreeNode.ReflectiveCtor
    public ArrayConstructor(FilePosition pos, Void value, List<? extends Expression> children) {
        this(pos, children);
    }

    public ArrayConstructor(FilePosition pos, List<? extends Expression> elements) {
        super(pos, Expression.class);
        this.createMutation().appendChildren(elements).execute();
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends Expression> children() {
        return this.childrenAs(Expression.class);
    }

    @Override
    public Boolean conditionResult() {
        return true;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        FilePosition pos = this.getFilePosition();
        out.mark(pos);
        out.consume("[");
        Expression last = null;
        for (Expression expression : this.children()) {
            if (last != null) {
                out.consume(",");
            }
            last = expression;
            if (!Operation.is((ParseTreeNode)expression, Operator.COMMA)) {
                if (expression instanceof Elision) continue;
                expression.render(rc);
                continue;
            }
            out.consume("(");
            expression.render(rc);
            out.consume(")");
        }
        out.mark(FilePosition.endOfOrNull(pos));
        out.consume("]");
    }

    @Override
    public String typeOf() {
        return "object";
    }

    @Override
    public JsonML toJsonML() {
        JsonMLCompatible.JsonMLBuilder builder = JsonMLCompatible.JsonMLBuilder.builder(TagType.ArrayExpr, this.getFilePosition());
        for (Expression expression : this.children()) {
            builder.addChild(expression instanceof Elision ? JsonMLCompatible.JsonMLBuilder.builder(TagType.Empty, expression.getFilePosition()).build() : expression.toJsonML());
        }
        return builder.build();
    }
}

