/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.RewriterTestCase;
import com.google.caja.util.FailureIsAnOption;
import junit.framework.AssertionFailedError;

public abstract class CommonJsRewriterTestCase
extends RewriterTestCase {
    public final void testIn() throws Exception {
        this.assertConsistent("('length' in {}) && fail('readable property mistaken for existing property');");
        this.assertConsistent("('length' in []) || fail('arrays should have a length');");
        this.assertConsistent("('x' in { x: 1 }) || fail('failed to find existing readable property');");
        this.assertConsistent("('y' in { x: 1 }) && fail('found nonexisting property');");
        this.assertConsistent("var flag = true;try { 'length' in '123'; }catch (e) { flag = false; }if (flag) { fail ('should throw TypeError'); }true;");
    }

    public final void testArrayLikeApply() throws Exception {
        this.assertConsistent("function x(a,b) { return a===0 && b===1; }function y() { return x.apply(null,arguments); }x.apply(null, [0,1]);");
        this.assertConsistent("function x(a,b) { return a===0 && b===1; }function y() { return x.apply(null,arguments); }y.apply(null, [0,1]);");
    }

    public final void testStringLength() throws Exception {
        this.assertConsistent("('123').length;");
    }

    public final void testEval() throws Exception {
        this.rewriteAndExecute("var success = false;try { eval('1'); } catch (e) { success = true; }if (!success) { fail('Outer eval is accessible.'); }");
    }

    public final void testMutableArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  try {    if (arguments[0] !== false || arguments.length !== 1) {       fail('arguments not initialized correctly');    }    arguments[0] = true;  } catch (e) {    fail('assignment to arguments failed');  }  if (a) { fail('Joined arguments'); }  if (!arguments[0]) { fail('arguments not mutated'); }}f(false);");
    }

    public final void testGetArgsCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.caller; } catch (e) { return; }  fail('arguments.caller did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetArgsCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.caller = 8; } catch (e) { return; }  fail('assigning to arguments.caller did not throw');}f();");
    }

    public final void testGetFuncCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { f.caller; } catch (e) { return; }  fail('<function>.caller did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetFuncCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { f.caller = 9; } catch (e) { return; }  fail('assigning to <function>.caller did not throw');}f();");
    }

    public final void testGetArgsCallee() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.callee; } catch (e) { return; }  fail('arguments.callee did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetArgsCallee() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.callee = 7; } catch (e) { return; }  fail('assigning to arguments.callee did not throw');}f();");
    }

    public final void testGetFuncArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();}\nfunction g() {  try { f.arguments; } catch (e) { return; }  fail('<function>.arguments did not throw');}f(false);");
    }

    @FailureIsAnOption
    public final void testSetFuncArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();}\nfunction g() {  try { f.arguments = 6; } catch (e) { return; }  fail('assigning to <function>.arguments did not throw');}f(false);");
    }

    public final void testCrossScopeArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();  if (a) { fail('Mutable cross scope arguments'); }}\nfunction g() {  var args;  try { args = f.arguments; } catch (e) { return; }  if (args) { args[0] = true; }}f(false);");
    }

    public final void testSameArguments() throws Exception {
        this.assertConsistent("function foo() {  return arguments === arguments;}foo();");
    }

    public final void testConcatArguments() throws Exception {
        this.assertConsistent("function foo() {  return [1].concat(arguments);}foo('a', 'b')[1][1];");
    }

    public final void testCatch() throws Exception {
        try {
            this.rewriteAndExecute("var e = false;try { throw true; } catch (e) {}if (e) { fail('Exception visible out of proper scope'); }");
            CommonJsRewriterTestCase.fail((String)"Exception that masks var should not pass");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testSetTimeout() throws Exception {
        this.rewriteAndExecute("var success=false;try { setTimeout('1',10); } catch(e) { success=true; }if (!success) { fail('setTimeout is accessible'); }");
    }

    public final void testObjectWatch() throws Exception {
        this.rewriteAndExecute("var x={}; var success=false;try { x.watch(y, function(){}); } catch(e) { success=true; }if (!success) { fail('Object.watch is accessible'); }");
    }

    public final void testForIn1() throws Exception {
        this.rewriteAndExecute("function Foo() {  return { x: 1, y: 2, z: 3 };}var obj = new Foo();var y = {};var result = [];for (y.k in obj) {  result.push(y.k);}assertEquals(    '' + result.sort(),    '' + ['x', 'y', 'z']);");
        this.rewriteAndExecute("function test(obj) {  var y = {};  var result = [];  for (y.k in obj) {    result.push(y.k);  }  return '' + result;}assertEquals('', test());");
        this.rewriteAndExecute("function Foo() {  return { x: 1, y: 2, z: 3 };}var obj = new Foo();var result = [];for (var k in obj)  result.push(k);assertEquals(    '' + result.sort(),    '' + ['x', 'y', 'z']);");
    }

    public final void testFor() throws Exception {
        this.assertConsistent("var i; for (i = 0; i < 10; i++) {} i;");
        this.assertConsistent("for (var i = 0; i < 10; i++) {} i;");
        this.assertConsistent("for (var i = 0, j = 0; i < 10; i++) { j += 10; } j;");
        this.assertConsistent("for (var i = 0, j = 0; i < 10; i++, j += 10) { } j;");
    }

    public final void testMultiDeclaration() throws Exception {
        this.assertConsistent("var a = 3, b = 4, c = 5; a + b + c;");
        this.assertConsistent("var a, b; a = 3; b = 4; a + b;");
        this.assertConsistent("  function f() {  var a = 3, b = 4;  return a + b; }f();");
    }

    public final void testCommonReformedGenerics() throws Exception {
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.call(x, 44);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.apply(x, [6,7,8]);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.bind(x)(6,7,8);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.bind(x,6)(7,8);x;");
        this.assertConsistent("[].push.length;");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo.call(x, 44);delete x.foo;x;");
    }

    public final void testTypeofConsistent() throws Exception {
        this.assertConsistent("[ (typeof noSuchGlobal),  (typeof 's'),  (typeof 4),  (typeof null),  (typeof (void 0)),  (typeof []),  (typeof {}),  (typeof (function () {})),  (typeof { x: 4.0 }.x),  (typeof { 2: NaN }[1 + 1])];");
    }

    public final void testCommonCallback() throws Exception {
        this.assertConsistent("'abc'.replace('b', function() {return 'xy';});");
        this.assertConsistent("var v = [1, 2, 3, 7, 4, 5];var cmp = function(a, b) {  return (a < b) ? +1 : (b < a) ? -1 : 0;};v.sort(cmp);");
        this.assertConsistent("(function(){}).bind.call(function(a, b) {return a + b;}, {}, 3)(4);");
    }

    public final void testErrorTaming() throws Exception {
        this.rewriteAndExecute("var t = new Error('foo');assertFalse(((typeof cajita !== 'undefined') ?    cajita :    Object).isFrozen(t));try {  throw t;} catch (ex) {  assertTrue(t === ex);}");
    }

    public final void testCommonJSONClass() throws Exception {
        this.rewriteAndExecute("assertTrue(({}).toString.call(JSON) === '[object JSON]');");
        this.rewriteAndExecute("assertTrue(JSON.toString() === '[object JSON]');");
    }

    public final void testFunctionClass() throws Exception {
        this.rewriteAndExecute("assertTrue(({}).toString.call(function(){})==='[object Function]')");
    }
}

