/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.opt.ArrayIndexOptimization;
import com.google.caja.parser.quasiliteral.opt.ScopeTree;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.RhinoTestBed;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIndexOptimizationTest
extends CajaTestCase {
    static final String REFERENCE_EXAMPLE = "var n = 3;return function (arr) {  var i = 0, j = 0, k, l = 0, m = 0, o = 1;  for (var i = 0; i < arr.length; ++i, m++) { arr[i] += j; }  j = arr[0].toString();  k = arr[1] ? i * 2 : i;  (function () {     l += x;   })();  o = m + 1;  return arr[i][j][k];};";
    private static Reference[] REFERENCES = new Reference[]{new Reference(ArrayIndexOptimizationTest.ident("undefined")), new Reference(ArrayIndexOptimizationTest.ident("nullValue")), new Reference(ArrayIndexOptimizationTest.ident("zero")), new Reference(ArrayIndexOptimizationTest.ident("negOne")), new Reference(ArrayIndexOptimizationTest.ident("posOne")), new Reference(ArrayIndexOptimizationTest.ident("truthy")), new Reference(ArrayIndexOptimizationTest.ident("untruthy")), new Reference(ArrayIndexOptimizationTest.ident("emptyString")), new Reference(ArrayIndexOptimizationTest.ident("numberLikeString")), new Reference(ArrayIndexOptimizationTest.ident("fooString")), new Reference(ArrayIndexOptimizationTest.ident("lengthString")), new Reference(ArrayIndexOptimizationTest.ident("anObj")), new Reference(ArrayIndexOptimizationTest.ident("sneaky")), new Reference(ArrayIndexOptimizationTest.ident("f"))};

    public final void testIsNumberOrUndefOperator() throws IOException {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        for (Operator op : Operator.values()) {
            if (!ArrayIndexOptimization.isNumberOrUndefOperator(op)) continue;
            Reference[] operands = new Reference[op.getType().getArity()];
            ArrayIndexOptimizationTest.fillOperands(op, 0, operands, stmts);
        }
        this.runArrayOptOperatorTest(stmts);
    }

    public final void testTestFramework() throws IOException {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        ArrayIndexOptimizationTest.fillOperands(Operator.ADDITION, 0, new Reference[2], stmts);
        try {
            this.runArrayOptOperatorTest(stmts);
        }
        catch (AssertionFailedError e) {
            return;
        }
        ArrayIndexOptimizationTest.fail((String)"Expected failure on foo+foo");
    }

    public final void testDoesVarReferenceArrayMember() throws Exception {
        ScopeTree global = ScopeTree.create(AncestorChain.instance(this.js(this.fromString(REFERENCE_EXAMPLE))));
        ScopeTree inner = global.children().get(0);
        ArrayIndexOptimizationTest.assertTrue((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("i")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertFalse((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("j")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertTrue((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("k")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertFalse((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("l")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertTrue((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("m")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertTrue((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("n")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertTrue((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("o")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertFalse((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("arr")), inner, new HashSet<String>()));
        ArrayIndexOptimizationTest.assertFalse((boolean)ArrayIndexOptimization.doesVarReferenceVisibleProperty(new Reference(ArrayIndexOptimizationTest.ident("x")), inner, new HashSet<String>()));
    }

    public final void testSimpleReferences() throws Exception {
        Block b = this.js(this.fromString("function map(f, arr) {\n  for (var i = 0, n = arr.length; i < n; ++i) {\n    f(arr[i]);\n  }\n}"));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function map(f, arr) {\n  for (var i = 0, n = arr.length; i < n; ++i) {\n    f(arr[+i]);\n  }\n}"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    public void checkReferenceChains() throws Exception {
        Block b = this.js(this.fromString(REFERENCE_EXAMPLE));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function map(f, arr) {\n  for (var i = 0, n = arr.length; i < n; ++i) {\n    f(arr[+i]);\n  }\n}"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    public final void testSubtraction() throws Exception {
        Block b = this.js(this.fromString("function lastOf(arr) {\n  return arr[arr.length - 1];\n}"));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function lastOf(arr) {\n  return arr[+(arr.length - 1)];\n}"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    public final void testAddition() throws Exception {
        Block b = this.js(this.fromString("function join(arr, sep) {\n  var s = '';\n  for (var i = 0; i < arr.length; i++) {    if (s && arr[i + 1]) { s += sep; }    s += arr[i];  }}join(myArray[foo + bar]);"));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function join(arr, sep) {\n  var s = '';\n  for (var i = 0; i < arr.length; i++) {    if (s && arr[+(i + 1)]) { s += sep; }    s += arr[+i];  }}join(myArray[foo + bar]);"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    public final void testCompoundAssignments() throws Exception {
        Block b = this.js(this.fromString("function lastIndexOf(arr, o) {\n  for (var i = arr.length; i > 0;) {\n    if (o === arr[--i]) { return i; }\n  }\n}"));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function lastIndexOf(arr, o) {\n  for (var i = arr.length; i > 0;) {\n    if (o === arr[+(--i)]) { return i; }\n  }\n}"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    public final void testConcatenation() throws Exception {
        Block b = this.js(this.fromString("function cheating(arr) {\n  return arr['length' + 'length'];\n}"));
        ArrayIndexOptimization.optimize(b);
        Block golden = this.js(this.fromString("function cheating(arr) {\n  return arr['length' + 'length'];\n}"));
        ArrayIndexOptimizationTest.assertEquals((String)ArrayIndexOptimizationTest.render(golden), (String)ArrayIndexOptimizationTest.render(b));
    }

    private void runArrayOptOperatorTest(List<Statement> stmts) throws IOException {
        RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "array-opt-operator-test.js"), new Executor.Input(ArrayIndexOptimizationTest.render(new Block(FilePosition.UNKNOWN, stmts)), this.getName()));
    }

    private static void fillOperands(Operator op, int operandIdx, Reference[] operands, List<Statement> out) {
        if (operandIdx == operands.length) {
            out.add(new ExpressionStmt(FilePosition.UNKNOWN, (Expression)QuasiBuilder.substV("requireArrayMember(function () { return @e; });", "e", Operation.create(FilePosition.UNKNOWN, op, operands))));
            return;
        }
        Reference[] arr$ = REFERENCES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Reference r;
            operands[operandIdx] = r = arr$[i$];
            ArrayIndexOptimizationTest.fillOperands(op, operandIdx + 1, operands, out);
        }
    }

    private static Identifier ident(String name) {
        return new Identifier(FilePosition.UNKNOWN, name);
    }
}

