/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral.opt;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.quasiliteral.opt.ScopeTree;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Join;
import java.util.Iterator;

public class ScopeTreeTest
extends CajaTestCase {
    public final void testConstructor() throws Exception {
        ScopeTree t = ScopeTree.create(AncestorChain.instance(this.js(this.fromString("function foo(j) {\n  var i = 0;\n  return j + 1;\n}\ntry {\n  var bar = (function () {\n     var i = 0;\n     function bar() {\n       return ++i;\n     }\n     return bar;\n  })();\n} catch (ex) {\n  panic(ex);\n}\n"))));
        ScopeTreeTest.assertEquals((String)"(ScopeTree Block\n  (ScopeTree function foo)\n  (ScopeTree function\n    (ScopeTree function bar))\n  (ScopeTree CatchStmt))", (String)t.toString());
    }

    public final void testUsesOf() throws Exception {
        ScopeTree t = ScopeTree.create(AncestorChain.instance(this.js(this.fromString("for (var i = 0; i < 1000; i++) alert('annoying innit');\nvar counter = (function () {\n  var i = -1;\n  return function () { return ++i; };\n})();"))));
        ScopeTree f1 = t.children().get(0);
        ScopeTree f2 = f1.children().get(0);
        Iterator<AncestorChain<Identifier>> uses = f2.usesOf("j").iterator();
        ScopeTreeTest.assertFalse((boolean)uses.hasNext());
        uses = f2.usesOf("i").iterator();
        ScopeTreeTest.assertTrue((boolean)uses.hasNext());
        ScopeTreeTest.assertEquals((String)Join.join((CharSequence)"\n", "Block", "  Declaration", "    SpecialOperation : FUNCTION_CALL", "      FunctionConstructor", "        Block", "          Declaration", "            Identifier : i"), (String)uses.next().toString());
        ScopeTreeTest.assertTrue((boolean)uses.hasNext());
        ScopeTreeTest.assertEquals((String)Join.join((CharSequence)"\n", "Block", "  Declaration", "    SpecialOperation : FUNCTION_CALL", "      FunctionConstructor", "        Block", "          ReturnStmt", "            FunctionConstructor", "              Block", "                ReturnStmt", "                  AssignOperation : PRE_INCREMENT", "                    Reference", "                      Identifier : i"), (String)uses.next().toString());
        ScopeTreeTest.assertFalse((boolean)uses.hasNext());
        uses = t.usesOf("i").iterator();
        ScopeTreeTest.assertTrue((boolean)uses.hasNext());
        ScopeTreeTest.assertEquals((String)Join.join((CharSequence)"\n", "Block", "  ForLoop : ", "    Declaration", "      Identifier : i"), (String)uses.next().toString());
        ScopeTreeTest.assertTrue((boolean)uses.hasNext());
        ScopeTreeTest.assertEquals((String)Join.join((CharSequence)"\n", "Block", "  ForLoop : ", "    SimpleOperation : LESS_THAN", "      Reference", "        Identifier : i"), (String)uses.next().toString());
        ScopeTreeTest.assertTrue((boolean)uses.hasNext());
        ScopeTreeTest.assertEquals((String)Join.join((CharSequence)"\n", "Block", "  ForLoop : ", "    ExpressionStmt", "      AssignOperation : POST_INCREMENT", "        Reference", "          Identifier : i"), (String)uses.next().toString());
        ScopeTreeTest.assertFalse((boolean)uses.hasNext());
    }
}

