/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.UriEffect;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandler;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Callback;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCajolingHandler
implements ContentHandler {
    protected final BuildInfo buildInfo;
    protected final UriFetcher uriFetcher;
    protected final String hostedService;

    public AbstractCajolingHandler(BuildInfo buildInfo, String hostedService, UriFetcher uriFetcher) {
        this.buildInfo = buildInfo;
        this.hostedService = hostedService;
        this.uriFetcher = uriFetcher != null ? uriFetcher : UriFetcher.NULL_NETWORK;
    }

    protected UriPolicy makeUriPolicy(final ContentHandlerArgs args) {
        return new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
                String protocol;
                boolean sandboxLinksAndImages;
                URI uri = u.getUri();
                boolean bl = sandboxLinksAndImages = !"false".equals(args.get("sext"));
                if ((effect == UriEffect.NEW_DOCUMENT && loader == LoaderType.UNSANDBOXED || effect == UriEffect.SAME_DOCUMENT && loader == LoaderType.SANDBOXED) && !sandboxLinksAndImages && ("http".equals(protocol = Strings.toLowerCase(uri.getScheme())) || "https".equals(protocol))) {
                    return uri.toString();
                }
                if (AbstractCajolingHandler.this.hostedService != null) {
                    return AbstractCajolingHandler.this.hostedService + "?url=" + UriUtil.encode(uri.toString()) + "&effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader) + "&sext=" + sandboxLinksAndImages;
                }
                return null;
            }
        };
    }

    @Override
    public abstract boolean canHandle(URI var1, CajolingService.Transform var2, List<CajolingService.Directive> var3, String var4, ContentTypeCheck var5);

    @Override
    public abstract Pair<String, String> apply(URI var1, CajolingService.Transform var2, List<CajolingService.Directive> var3, ContentHandlerArgs var4, String var5, ContentTypeCheck var6, FetchedData var7, OutputStream var8, MessageQueue var9) throws UnsupportedContentTypeException;

    private static StringLiteral lit(String s) {
        return StringLiteral.valueOf(FilePosition.UNKNOWN, s);
    }

    private static IntegerLiteral lit(int i) {
        return new IntegerLiteral(FilePosition.UNKNOWN, i);
    }

    private static ArrayConstructor arr(List<? extends Expression> items) {
        return new ArrayConstructor(FilePosition.UNKNOWN, items);
    }

    private static ObjectConstructor obj(List<? extends ValueProperty> props) {
        return new ObjectConstructor(FilePosition.UNKNOWN, props);
    }

    private static ValueProperty prop(String key, Expression e) {
        return new ValueProperty(FilePosition.UNKNOWN, AbstractCajolingHandler.lit(key), e);
    }

    static boolean checkIdentifier(String candidate) {
        Block node;
        SimpleMessageQueue mq = new SimpleMessageQueue();
        Parser parser = new Parser(new JsTokenQueue(new JsLexer(CharProducer.Factory.fromString((CharSequence)("var " + candidate + ";"), InputSource.UNKNOWN)), InputSource.UNKNOWN), mq);
        try {
            node = parser.parse();
        }
        catch (ParseException e) {
            return false;
        }
        if (node == null || !mq.getMessages().isEmpty()) {
            return false;
        }
        Map<String, ParseTreeNode> bindings = Maps.newHashMap();
        if (!QuasiBuilder.match("{ var @p; }", node, bindings)) {
            return false;
        }
        if (bindings.size() != 1) {
            return false;
        }
        if (bindings.get("p") == null) {
            return false;
        }
        if (!(bindings.get("p") instanceof Identifier)) {
            return false;
        }
        Identifier p = (Identifier)bindings.get("p");
        return candidate.equals(p.getName());
    }

    protected void renderAsJSON(Node staticHtml, ParseTreeNode javascript, String jsonpCallback, MessageQueue mq, Appendable output) throws IOException {
        List<ValueProperty> props = Lists.newArrayList();
        if (staticHtml != null) {
            props.add(AbstractCajolingHandler.prop("html", AbstractCajolingHandler.lit(Nodes.render(staticHtml))));
        }
        if (javascript != null) {
            props.add(AbstractCajolingHandler.prop("js", AbstractCajolingHandler.lit(this.renderJavascript(javascript))));
        }
        if (mq.hasMessageAtLevel(MessageLevel.LOG)) {
            List<ObjectConstructor> messages = Lists.newArrayList();
            for (Message m : mq.getMessages()) {
                messages.add(AbstractCajolingHandler.obj(Arrays.asList(AbstractCajolingHandler.prop("level", AbstractCajolingHandler.lit(m.getMessageLevel().ordinal())), AbstractCajolingHandler.prop("name", AbstractCajolingHandler.lit(m.getMessageLevel().name())), AbstractCajolingHandler.prop("type", AbstractCajolingHandler.lit(m.getMessageType().name())), AbstractCajolingHandler.prop("message", AbstractCajolingHandler.lit(m.toString())))));
            }
            props.add(AbstractCajolingHandler.prop("messages", AbstractCajolingHandler.arr(messages)));
        }
        if (jsonpCallback != null && !AbstractCajolingHandler.checkIdentifier(jsonpCallback)) {
            throw new RuntimeException("Detected XSS attempt; aborting request");
        }
        ObjectConstructor result = jsonpCallback == null ? AbstractCajolingHandler.obj(props) : QuasiBuilder.substV("@c(@o);", "c", new Reference(new Identifier(FilePosition.UNKNOWN, jsonpCallback)), "o", AbstractCajolingHandler.obj(props));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IOCallback
        implements Callback<IOException> {
            IOException ex;

            IOCallback() {
            }

            @Override
            public void handle(IOException e) {
                if (this.ex != null) {
                    this.ex = e;
                }
            }
        }
        IOCallback callback = new IOCallback();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(output, callback))).withJson(true);
        result.render(rc);
        rc.getOut().noMoreTokens();
        if (callback.ex != null) {
            throw callback.ex;
        }
    }

    protected String renderJavascript(ParseTreeNode javascript) {
        StringBuilder jsOut = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(jsOut))).withEmbeddable(true);
        javascript.render(rc);
        rc.getOut().noMoreTokens();
        return jsOut.toString();
    }

    protected Pair<ContentType, String> getReturnedContentParams(ContentHandlerArgs args) {
        String alt = CajaArguments.ALT.get(args);
        if ("json".equals(alt) || alt == null) {
            return Pair.pair(ContentType.JSON, null);
        }
        if ("json-in-script".equals(alt)) {
            String callback = CajaArguments.CALLBACK.get(args);
            if (callback == null) {
                throw new RuntimeException("Missing value for parameter " + (Object)((Object)CajaArguments.CALLBACK));
            }
            return Pair.pair(ContentType.JS, callback);
        }
        throw new RuntimeException("Invalid value " + alt + " for parameter " + (Object)((Object)CajaArguments.ALT));
    }
}

