/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.service.AbstractCajolingHandler;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.ServiceMessageType;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlHandler
extends AbstractCajolingHandler {
    public HtmlHandler(BuildInfo buildInfo, String hostedService, UriFetcher uriFetcher) {
        super(buildInfo, hostedService, uriFetcher);
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, ContentTypeCheck checker) {
        return checker.check("text/html", inputContentType) && (transform == null || transform == CajolingService.Transform.CAJOLE);
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, ContentHandlerArgs args, String inputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        PluginMeta meta = new PluginMeta(this.uriFetcher, this.makeUriPolicy(args));
        meta.setIdClass(args.get("idclass"));
        boolean htmlInline = CajaArguments.EMIT_HTML_IN_JS.get(args) != null && Boolean.valueOf(CajaArguments.EMIT_HTML_IN_JS.get(args)) != false;
        Pair<ContentType, String> contentParams = this.getReturnedContentParams(args);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8);
            this.cajoleHtml(uri, input.getTextualContent(), meta, (String)contentParams.b, htmlInline, writer, mq);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
        return Pair.pair(((ContentType)((Object)contentParams.a)).mimeType, Charsets.UTF_8.name());
    }

    private void cajoleHtml(URI inputUri, CharProducer cp, PluginMeta meta, String jsonpCallback, boolean htmlInline, Appendable output, MessageQueue mq) {
        InputSource is = new InputSource(inputUri);
        boolean okToContinue = true;
        try {
            PluginCompiler compiler = new PluginCompiler(this.buildInfo, meta, mq);
            if (htmlInline) {
                compiler.setGoals(compiler.getGoals().without(PipelineMaker.HTML_SAFE_STATIC));
            }
            Dom html = null;
            try {
                DomParser p = new DomParser(new HtmlLexer(cp), false, is, mq);
                html = new Dom(p.parseFragment());
                p.getTokenQueue().expectEmpty();
            }
            catch (ParseException e) {
                okToContinue = false;
            }
            if (okToContinue) {
                compiler.addInput(html, inputUri);
                okToContinue &= compiler.run();
            }
            this.renderAsJSON(okToContinue ? compiler.getStaticHtml() : null, okToContinue ? compiler.getJavascript() : null, jsonpCallback, mq, output);
        }
        catch (IOException e) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.IO_ERROR, MessagePart.Factory.valueOf(e.getMessage()));
        }
    }

    public boolean sandboxLinksAndImages(URI inputUri) {
        return !HtmlHandler.hasParameter(inputUri.getRawQuery(), "sext=false");
    }

    private static boolean hasParameter(String query, String param) {
        if (query == null) {
            return false;
        }
        int pos = 0;
        int n = query.length();
        if (n >= 1 && query.charAt(0) == '?') {
            pos = 1;
        }
        while (pos < n) {
            int end = query.indexOf(38, pos);
            if (end < 0) {
                end = n;
            }
            String rawParam = query.substring(pos, end);
            try {
                if (URLEncoder.encode(rawParam, "UTF-8").equals(param)) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new SomethingWidgyHappenedError(ex);
            }
            pos = end + 1;
        }
        return false;
    }
}

