/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.reporting.MessageLevel;
import com.google.caja.service.ServiceTestCase;
import junit.framework.AssertionFailedError;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class HtmlHandlerTest
extends ServiceTestCase {
    public final void testHtml2Json() throws Exception {
        this.assertHtml2Json("*/*");
        this.assertHtml2Json("text/html");
        this.assertHtml2Json("text/html");
    }

    public final void testHtmlWithJsonpCallback() throws Exception {
        this.registerUri("http://foo/bar.html", "<p>some random text</p>", "text/html");
        String s = (String)this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html&alt=json-in-script&callback=foo");
        HtmlHandlerTest.assertCallbackInJsonp(s, "foo");
        HtmlHandlerTest.assertSubstringsInJsonp(s, "html", "some random text");
        try {
            HtmlHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html&alt=json-in-script&callback=foo.bar"), "foo.bar");
            HtmlHandlerTest.fail((String)"Failed to reject non-identifier JSONP callback");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            HtmlHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html&callback=foo.bar"), "foo.bar");
            HtmlHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            HtmlHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html&alt=json&callback=foo.bar"), "foo.bar");
            HtmlHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testSandboxedLink() throws Exception {
        this.registerUri("http://foo/bar.css", "a { background-image: url(baz.png) }", "text/css");
        this.registerUri("http://foo/index.html", "<link rel=stylesheet href=bar.css><a href=\"shizzle.html\">Clicky</a>", "text/html");
        String result = (String)this.requestGet("?url=http://foo/index.html&input-mime-type=text/html&output-mime-type=text/html&sext=true&idclass=foo___");
        JSONObject json = (JSONObject)HtmlHandlerTest.json(result);
        HtmlHandlerTest.assertContainsIgnoreSpace((String)json.get((Object)"html"), " background-image: url('http://caja.appspot.com/cajole?url=http%3a%2f%2fcaja.appspot.com%2fcajole%3furl%3dhttp%253a%252f%252ffoo%252fbaz.png%26effect%3dSAME%5fDOCUMENT%26loader%3dSANDBOXED%26sext%3dtrue&effect=SAME%5fDOCUMENT&loader=SANDBOXED&sext=true')");
        HtmlHandlerTest.assertContainsIgnoreSpace((String)json.get((Object)"html"), "<a href=\"http://caja.appspot.com/cajole?url=http%3a%2f%2ffoo%2fshizzle.html&amp;effect=NEW_DOCUMENT&amp;loader=UNSANDBOXED&amp;sext=true\" target=\"_blank\">");
    }

    public final void testUnsandboxedLink() throws Exception {
        this.registerUri("http://foo/bar.css", "a { background-image: url(baz.png) }", "text/css");
        this.registerUri("http://foo/index.html", "<link rel=stylesheet href=bar.css><a href=\"shizzle.html\">Clicky</a>", "text/html");
        String result = (String)this.requestGet("?url=http://foo/index.html&input-mime-type=text/html&output-mime-type=text/html&sext=false&idclass=foo___");
        JSONObject json = (JSONObject)HtmlHandlerTest.json(result);
        HtmlHandlerTest.assertContainsIgnoreSpace((String)json.get((Object)"html"), "background-image: url('http://foo/baz.png')");
        HtmlHandlerTest.assertContainsIgnoreSpace((String)json.get((Object)"html"), "<a href=\"http://foo/shizzle.html\" target=\"_blank\">Clicky</a>");
    }

    private void assertHtml2Json(String inputMimeType) throws Exception {
        this.registerUri("http://foo/bar.html", "<p>hi</p><script>42;</script><p>bye</p>", "text/html");
        Object result = HtmlHandlerTest.json((String)this.requestGet("?url=http://foo/bar.html&input-mime-type=" + inputMimeType));
        HtmlHandlerTest.assertNotNull((Object)result);
        HtmlHandlerTest.assertTrue((boolean)(result instanceof JSONObject));
        JSONObject json = (JSONObject)result;
        HtmlHandlerTest.assertEquals((String)"<p>hi<span id=\"id_1___\"></span></p><p>bye</p>", (String)((String)json.get((Object)"html")));
        HtmlHandlerTest.assertEquals((String)"{___.loadModule({'instantiate':function(___,IMPORTS___){return ___.prepareModule({'instantiate':function(___,IMPORTS___){var\nmoduleResult___,el___,emitter___;moduleResult___=___.NO_RESULT;{emitter___=IMPORTS___.htmlEmitter___;emitter___.discard(emitter___.attach('id_1___'))}return moduleResult___},'cajolerName':'com.google.caja','cajolerVersion':'testBuildVersion','cajoledDate':0})(IMPORTS___),___.prepareModule({'instantiate':function(___,IMPORTS___){var\n$v=___.readImport(IMPORTS___,'$v',{'getOuters':{'()':{}},'initOuter':{'()':{}},'ro':{'()':{}}});var\nmoduleResult___,$dis;moduleResult___=___.NO_RESULT;$dis=$v.getOuters();$v.initOuter('onerror');try{{moduleResult___=42}}catch(ex___){___.getNewModuleHandler().handleUncaughtException(ex___,$v.ro('onerror'),'bar.html','1')}return moduleResult___},'cajolerName':'com.google.caja','cajolerVersion':'testBuildVersion','cajoledDate':0})(IMPORTS___),___.prepareModule({'instantiate':function(___,IMPORTS___){var\nmoduleResult___,el___,emitter___;moduleResult___=___.NO_RESULT;{emitter___=IMPORTS___.htmlEmitter___;el___=emitter___.finish();emitter___.signalLoaded()}return moduleResult___},'cajolerName':'com.google.caja','cajolerVersion':'testBuildVersion','cajoledDate':0})(IMPORTS___)},'cajolerName':'com.google.caja','cajolerVersion':'testBuildVersion','cajoledDate':0})}", (String)((String)json.get((Object)"js")));
        HtmlHandlerTest.assertTrue((boolean)(json.get((Object)"messages") instanceof JSONArray));
        JSONArray messages = (JSONArray)json.get((Object)"messages");
        this.assertMessagesLessSevereThan(messages, MessageLevel.ERROR);
    }

    public final void testErrors2Json() throws Exception {
        this.registerUri("http://foo/bar.html", "<script>with(foo){}</script>", "text/html");
        Object result = HtmlHandlerTest.json((String)this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html"));
        HtmlHandlerTest.assertTrue((boolean)(result instanceof JSONObject));
        JSONObject json = (JSONObject)result;
        HtmlHandlerTest.assertTrue((boolean)json.containsKey((Object)"messages"));
        JSONArray messages = (JSONArray)json.get((Object)"messages");
        boolean containsError = false;
        for (Object msg : messages) {
            JSONObject jsonMsg = (JSONObject)msg;
            containsError = containsError || jsonMsg.get((Object)"name").equals("ERROR");
        }
        HtmlHandlerTest.assertTrue((boolean)containsError);
    }
}

