/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.service.ServiceTestCase;
import junit.framework.AssertionFailedError;

public class InnocentHandlerTest
extends ServiceTestCase {
    public final void testInnocentJs() throws Exception {
        this.registerUri("http://foo/innocent.js", "for (var k in x) { k; }", "text/javascript");
        InnocentHandlerTest.assertSubstringsInJson((String)this.requestGet("?url=http://foo/innocent.js&input-mime-type=text/javascript&transform=INNOCENT"), "js", "if (x0___.match(/___$/)) { continue }");
    }

    public final void testInnocentJsWithJsonpCallback() throws Exception {
        this.registerUri("http://foo/innocent.js", "for (var k in x) { k; }", "text/javascript");
        String s = (String)this.requestGet("?url=http://foo/innocent.js&input-mime-type=text/javascript&transform=INNOCENT&alt=json-in-script&callback=foo");
        InnocentHandlerTest.assertCallbackInJsonp(s, "foo");
        InnocentHandlerTest.assertSubstringsInJsonp(s, "js", "if (x0___.match(/___$/)) { continue }");
        try {
            InnocentHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/innocent.js&input-mime-type=text/javascript&transform=INNOCENT&alt=json-in-script&callback=foo.bar"), "foo.bar");
            InnocentHandlerTest.fail((String)"Failed to reject non-identifier JSONP callback");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            InnocentHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/innocent.js&input-mime-type=text/javascript&transform=INNOCENT&callback=foo.bar"), "foo.bar");
            InnocentHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
        try {
            InnocentHandlerTest.assertCallbackInJsonp((String)this.requestGet("?url=http://foo/innocent.js&input-mime-type=text/javascript&transform=INNOCENT&alt=json&callback=foo.bar"), "foo.bar");
            InnocentHandlerTest.fail((String)"Added JSONP callback when not requested");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }
}

