/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.JavaTypes;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;

public class ArrayProperty
extends ScalarProperty {
    private static final long serialVersionUID = 0L;

    public ArrayProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    public ListType getType() {
        return (ListType)super.getType();
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value.getClass().isArray();
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            Class klass = JavaTypes.getClass((Type)this.getType().getFieldType());
            return col.toArray((Object[])Array.newInstance(klass, col.size()));
        }
        throw new PropertyConversionException(value.getClass(), Object[].class, this.getPath());
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (toType.isArray()) {
            return (T)PrimitiveArrays.toObjectArray((Object)value);
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return (T)Arrays.asList((Object[])value);
        }
        throw new PropertyConversionException(value.getClass(), toType);
    }

    @Override
    public Object newInstance() {
        return new Serializable[0];
    }
}

