/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="lock", type="LockService", targetType="Document")
public class LockService
extends DefaultAdapter {
    @GET
    public Object doGet() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            return this.ctx.getCoreSession().getLock(doc.getRef());
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get lock on document", (Throwable)e);
        }
    }

    @DELETE
    public Object removeLock() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().unlock(doc.getRef());
            doc.refresh();
            return null;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to unlock document", (Throwable)e);
        }
    }

    @POST
    public Object doPost() {
        try {
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            this.ctx.getCoreSession().setLock(doc.getRef(), this.ctx.getPrincipal().getName());
            doc.refresh();
            return null;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to lock document", (Throwable)e);
        }
    }
}

