/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.DocumentIndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl.AbstractNXCoreIndexableResource;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;

public class DocumentIndexableResourceImpl
extends AbstractNXCoreIndexableResource
implements DocumentIndexableResource {
    private static final long serialVersionUID = 782382133065340451L;
    private static final Log log = LogFactory.getLog(DocumentIndexableResourceImpl.class);
    public static final String BLOB_DATA_KEY = "data";
    public static final String BLOB_ENCODING_KEY = "encoding";
    public static final String BLOB_MIMETYPE_KEY = "mime-type";
    public static final String BLOB_DIGEST_KEY = "digest";
    public static final String BLOB_NAME_KEY = "name";
    public static final String BLOB_LENGTH_KEY = "length";
    protected String docUUID;
    protected DocumentRef docRef;
    protected DocumentRef docParentRef;
    protected Path docPath;
    protected String docURL;
    protected String docType;
    protected String docVersionLabel;
    protected String docName;
    protected String docCurrentLifeCycle;
    protected ACP docAcp;
    protected Boolean isDocVersion;
    protected Boolean isDocProxy;
    protected List<String> docFacets;
    protected Set<String> docSchemas;
    protected DocumentModel targetDoc;
    protected Long flags = 0L;

    public DocumentIndexableResourceImpl() {
    }

    public DocumentIndexableResourceImpl(DocumentModel dm, IndexableResourceConf conf, String sid) {
        super(conf != null ? conf.getName() : null, conf, sid, dm.getRepositoryName());
        this.docUUID = dm.getId();
        this.docRef = dm.getRef();
        this.docParentRef = dm.getParentRef();
        this.docPath = dm.getPath();
        this.docURL = "foo/bar";
        this.docType = dm.getType();
        this.docVersionLabel = dm.getVersionLabel();
        this.isDocVersion = dm.isVersion();
        this.isDocProxy = dm.isProxy();
        this.docName = dm.getName();
        this.targetDoc = dm;
        if (dm.isLifeCycleLoaded()) {
            try {
                this.docCurrentLifeCycle = dm.getCurrentLifeCycleState();
            }
            catch (ClientException e) {
                log.warn((Object)"Cannot get additionial document model properties.");
            }
        }
        try {
            this.docAcp = dm.getACP();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        this.docFacets = dm.getDeclaredFacets() != null ? new ArrayList<String>(dm.getDeclaredFacets()) : Collections.emptyList();
        String[] schemas = dm.getDeclaredSchemas();
        if (schemas != null) {
            this.docSchemas = new HashSet<String>();
            this.docSchemas.addAll(Arrays.asList(schemas));
        } else {
            this.docSchemas = Collections.emptySet();
        }
        if (dm instanceof DocumentModelImpl) {
            this.flags = dm.getFlags();
        }
    }

    @Override
    public DocumentRef getDocRef() {
        return this.docRef;
    }

    protected Serializable extractComplexProperty(Serializable complex, String subField) {
        if (complex == null) {
            return null;
        }
        if (complex instanceof List) {
            List l = (List)((Object)complex);
            ArrayList<Serializable> res = new ArrayList<Serializable>(l.size());
            for (Serializable s : l) {
                res.add(this.extractComplexProperty(s, subField));
            }
            return res;
        }
        if (complex instanceof Map) {
            return (Serializable)((Map)((Object)complex)).get(subField);
        }
        if (complex instanceof Blob) {
            Blob blob = (Blob)complex;
            if (BLOB_ENCODING_KEY.equals(subField)) {
                return blob.getEncoding();
            }
            if (BLOB_MIMETYPE_KEY.equals(subField)) {
                return blob.getMimeType();
            }
            if (BLOB_DIGEST_KEY.equals(subField)) {
                return blob.getDigest();
            }
            if (BLOB_LENGTH_KEY.equals(subField)) {
                return Long.valueOf(blob.getLength());
            }
            if (BLOB_NAME_KEY.equals(subField)) {
                return blob.getFilename();
            }
            if (BLOB_DATA_KEY.equals(subField)) {
                return (Serializable)blob;
            }
            log.warn((Object)("Unknown sub-property for Blob: " + subField));
            return (Serializable)blob;
        }
        return complex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getValueFor(String indexableDataName) throws IndexingException {
        Serializable res;
        block9: {
            String[] split = indexableDataName.split(":", 3);
            if (split.length < 2) {
                log.warn((Object)("Invalid field name: " + indexableDataName));
                return null;
            }
            String schemaPrefix = split[0];
            if (!this.docSchemas.contains(schemaPrefix)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Document %s (type=%s) does not bear schema %s", this.docUUID, this.docType, schemaPrefix));
                }
                return null;
            }
            String fieldName = split[1];
            res = null;
            try {
                this.login();
                if (this.docRef == null) break block9;
                try {
                    res = this.targetDoc != null ? (Serializable)this.targetDoc.getProperty(schemaPrefix, fieldName) : (Serializable)this.getCoreSession().getDataModelField(this.docRef, schemaPrefix, fieldName);
                    if (split.length > 2) {
                        res = this.extractComplexProperty(res, split[2]);
                    }
                }
                catch (ClientException ce) {
                    throw new IndexingException(ce);
                }
            }
            finally {
                this.logout();
            }
        }
        return res;
    }

    @Override
    public DocumentRef getDocParentRef() {
        return this.docParentRef;
    }

    @Override
    public Path getDocPath() {
        return this.docPath;
    }

    @Override
    public String getDocType() {
        return this.docType;
    }

    @Override
    public String getDocURL() {
        return this.docURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ACP getDocMergedACP() throws IndexingException {
        if (this.docAcp == null) {
            try {
                this.login();
                this.docAcp = this.getCoreSession().getACP(this.docRef);
            }
            catch (ClientException e) {
                log.error((Object)"Cannot get ACP from core...");
            }
            finally {
                this.logout();
            }
        }
        return this.docAcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDocCurrentLifeCycleState() {
        if (this.docCurrentLifeCycle == null) {
            try {
                this.login();
                this.coreSession = this.getCoreSession();
                this.docCurrentLifeCycle = this.coreSession.getCurrentLifeCycleState(this.docRef);
            }
            catch (Exception e) {
                log.error((Object)"Cannot get life cycle from core...");
            }
            finally {
                this.logout();
            }
        }
        return this.docCurrentLifeCycle;
    }

    @Override
    public String getDocUUID() {
        return this.docUUID;
    }

    @Override
    public String computeId() {
        return this.getQid() + '-' + this.getName();
    }

    @Override
    public String getDocVersionLabel() {
        return this.docVersionLabel;
    }

    @Override
    public Boolean isDocVersion() {
        return this.isDocVersion;
    }

    @Override
    public String getQid() {
        return this.getDocRepositoryName() + ':' + this.docUUID;
    }

    @Override
    public String getDocName() {
        return this.docName;
    }

    @Override
    public Boolean isDocProxy() {
        return this.isDocProxy;
    }

    @Override
    public List<String> getDocFacets() {
        if (this.docFacets != null) {
            return this.docFacets;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "DocumentIndexableResourceImpl<" + this.getName() + " for document " + this.docUUID + '>';
    }

    @Override
    public Long getFlags() {
        return this.flags;
    }
}

