/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.Service;
import org.jboss.system.ServiceBinding;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceFactory;
import org.w3c.dom.Element;

public class ServiceController
extends JBossNotificationBroadcasterSupport
implements ServiceControllerMBean,
MBeanRegistration {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    public static final String JBOSS_INTERNAL_LIFECYCLE = "jbossInternalLifecycle";
    public static final String[] JBOSS_INTERNAL_LIFECYCLE_SIG = new String[]{String.class.getName()};
    private static final Logger log = Logger.getLogger((Class)ServiceController.class);
    protected MBeanServer server;
    protected ServiceCreator creator;
    protected ServiceConfigurator configurator;
    protected Map nameToServiceMap = Collections.synchronizedMap(new HashMap());
    protected List installedServices = new LinkedList();
    private static HashMap serviceOpMap = new HashMap();

    public void setServiceBinding(ServiceBinding serviceBinding) {
        if (this.configurator != null) {
            this.configurator.setServiceBinding(serviceBinding);
        }
    }

    public List listDeployed() {
        return new ArrayList(this.installedServices);
    }

    public List listIncompletelyDeployed() {
        ArrayList<ServiceContext> id = new ArrayList<ServiceContext>();
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            ServiceContext sc = (ServiceContext)i.next();
            if (sc.state == 2 || sc.state == 3 || sc.state == 5 || sc.state == 6) continue;
            id.add(sc);
        }
        return id;
    }

    public List listDeployedNames() {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.installedServices.size());
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            ServiceContext ctx = (ServiceContext)i.next();
            names.add(ctx.objectName);
        }
        return names;
    }

    public String listConfiguration(ObjectName[] objectNames) throws Exception {
        return this.configurator.getConfiguration(objectNames);
    }

    public void validateDeploymentState(DeploymentInfo di, DeploymentState state) {
        ArrayList<ObjectName> mbeans = new ArrayList<ObjectName>(di.mbeans);
        if (di.deployedObject != null) {
            mbeans.add(di.deployedObject);
        }
        boolean mbeansStateIsValid = true;
        for (int m = 0; m < mbeans.size(); ++m) {
            ObjectName serviceName = (ObjectName)mbeans.get(m);
            ServiceContext ctx = this.getServiceContext(serviceName);
            if (ctx == null || state != DeploymentState.STARTED) continue;
            mbeansStateIsValid &= ctx.state == 3;
        }
        if (mbeansStateIsValid) {
            di.state = state;
        }
    }

    public synchronized List install(Element config, ObjectName loaderName) throws DeploymentException {
        List mbeans = this.configurator.install(config, loaderName);
        Iterator i = mbeans.iterator();
        while (i.hasNext()) {
            ObjectName mbean = (ObjectName)i.next();
            this.installedServices.add(this.createServiceContext(mbean));
        }
        return mbeans;
    }

    public synchronized void register(ObjectName serviceName) throws Exception {
        this.register(serviceName, null);
    }

    public synchronized void register(ObjectName serviceName, Collection depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to register null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Registering service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        this.register(ctx, depends);
    }

    public synchronized void create(ObjectName serviceName) throws Exception {
        this.create(serviceName, null);
    }

    public synchronized void create(ObjectName serviceName, Collection depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to create null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Creating service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        this.register(ctx, depends);
        if (ctx.state == 2 || ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring create request for service: " + ctx.objectName));
            return;
        }
        int oldState = ctx.state;
        ctx.state = 2;
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext sc = (ServiceContext)iterator.next();
            int state = sc.state;
            if (state == 2 || state == 3) continue;
            log.debug((Object)("waiting in create of " + serviceName + " waiting on " + sc.objectName));
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.create();
            this.sendControllerNotification("org.jboss.system.ServiceMBean.create", serviceName);
        }
        catch (Throwable e) {
            ctx.state = 4;
            ctx.problem = e;
            log.warn((Object)("Problem creating service " + serviceName), e);
            return;
        }
        log.debug((Object)("Creating dependent components for: " + serviceName + " dependents are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            this.create(ctx2.objectName);
        }
        tmp.clear();
    }

    public synchronized void start(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to start null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("starting service " + serviceName));
        ServiceContext ctx = this.createServiceContext(serviceName);
        if (!this.installedServices.contains(ctx)) {
            this.installedServices.add(ctx);
        }
        if (ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring start request for service: " + ctx.objectName));
            return;
        }
        if (ctx.state != 2 && ctx.state != 5) {
            log.debug((Object)("Start requested before create, calling create now for service: " + serviceName));
            this.create(serviceName);
        }
        if (ctx.proxy == null) {
            ctx.proxy = this.getServiceProxy(ctx.objectName, null);
        }
        int oldState = ctx.state;
        ctx.state = 3;
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext sctx = (ServiceContext)iterator.next();
            int state = sctx.state;
            if (state == 3) continue;
            log.debug((Object)("waiting in start " + serviceName + " on " + sctx.objectName));
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.start();
            this.sendControllerNotification("org.jboss.system.ServiceMBean.start", serviceName);
        }
        catch (Throwable e) {
            ctx.state = 4;
            ctx.problem = e;
            log.warn((Object)("Problem starting service " + serviceName), e);
            return;
        }
        log.debug((Object)("Starting dependent components for: " + serviceName + " dependent components: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            this.start(ctx2.objectName);
        }
        tmp.clear();
    }

    public void restart(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to restart null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("restarting service " + serviceName));
        this.stop(serviceName);
        this.start(serviceName);
    }

    public void stop(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to stop null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        log.debug((Object)("stopping service: " + serviceName));
        if (ctx == null) {
            log.warn((Object)("Ignoring request to stop nonexistent service: " + serviceName));
            return;
        }
        if (ctx.state != 3) {
            return;
        }
        ctx.state = 5;
        log.debug((Object)("stopping dependent services for: " + serviceName + " dependent services are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            ObjectName other = ctx2.objectName;
            this.stop(other);
        }
        tmp.clear();
        if (ctx.proxy != null) {
            try {
                ctx.proxy.stop();
                this.sendControllerNotification("org.jboss.system.ServiceMBean.stop", serviceName);
            }
            catch (Throwable e) {
                ctx.state = 4;
                ctx.problem = e;
                log.warn((Object)("Problem stopping service " + serviceName), e);
            }
        }
    }

    public void destroy(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to destroy null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        log.debug((Object)("destroying service: " + serviceName));
        if (ctx == null) {
            log.warn((Object)("Ignoring request to destroy nonexistent service: " + serviceName));
            return;
        }
        if (ctx.state == 6 || ctx.state == 7) {
            return;
        }
        if (ctx.state == 3) {
            log.debug((Object)("Destroy requested before stop, calling stop now for service: " + serviceName));
            this.stop(serviceName);
        }
        ctx.state = 6;
        log.debug((Object)("destroying dependent services for: " + serviceName + " dependent services are: " + ctx.dependsOnMe));
        ArrayList tmp = new ArrayList(ctx.dependsOnMe);
        for (int n = 0; n < tmp.size(); ++n) {
            ServiceContext ctx2 = (ServiceContext)tmp.get(n);
            ObjectName other = ctx2.objectName;
            this.destroy(other);
        }
        tmp.clear();
        if (ctx.proxy != null) {
            try {
                ctx.proxy.destroy();
                this.sendControllerNotification("org.jboss.system.ServiceMBean.destroy", serviceName);
            }
            catch (Throwable e) {
                ctx.state = 4;
                ctx.problem = e;
                log.warn((Object)("Problem destroying service " + serviceName), e);
            }
        }
    }

    public void remove(ObjectName objectName) throws Exception {
        if (objectName == null) {
            log.warn((Object)"Ignoring request to remove null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(objectName);
        if (ctx == null) {
            log.trace((Object)("Ignoring request to remove nonexistent service: " + objectName));
            return;
        }
        log.debug((Object)("removing service: " + objectName));
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext iDependOnContext = (ServiceContext)iterator.next();
            iDependOnContext.dependsOnMe.remove(ctx);
            if (iDependOnContext.state != 7 || iDependOnContext.dependsOnMe.size() != 0) continue;
            this.nameToServiceMap.remove(iDependOnContext.objectName);
            log.debug((Object)("Removing context for nonexistent service it is no longer recording dependencies: " + iDependOnContext));
        }
        ctx.iDependOn.clear();
        if (this.server.isRegistered(objectName)) {
            log.debug((Object)("removing " + objectName + " from server"));
            if (ctx.dependsOnMe.size() == 0) {
                this.nameToServiceMap.remove(objectName);
            } else {
                log.debug((Object)("Context not removed, it is recording dependencies: " + ctx));
                ctx.proxy = null;
            }
            this.installedServices.remove(ctx);
            this.creator.remove(objectName);
        } else {
            this.installedServices.remove(ctx);
            if (ctx.dependsOnMe.size() == 0) {
                log.debug((Object)("removing already unregistered " + objectName + " from server"));
                this.nameToServiceMap.remove(objectName);
            } else {
                log.debug((Object)("no need to remove " + objectName + " from server"));
                ctx.proxy = null;
            }
        }
        ctx.state = 7;
    }

    public ServiceContext getServiceContext(ObjectName serviceName) {
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        return ctx;
    }

    public void shutdown() {
        log.debug((Object)("Stopping " + this.nameToServiceMap.size() + " services"));
        ArrayList servicesCopy = new ArrayList(this.installedServices);
        int serviceCounter = 0;
        ObjectName name = null;
        ListIterator i = servicesCopy.listIterator(servicesCopy.size());
        while (i.hasPrevious()) {
            ServiceContext ctx = (ServiceContext)i.previous();
            name = ctx.objectName;
            try {
                this.stop(name);
            }
            catch (Throwable e) {
                log.error((Object)("Could not stop mbean: " + name), e);
            }
            try {
                this.destroy(name);
            }
            catch (Throwable e) {
                log.error((Object)("Could not destroy mbean: " + name), e);
            }
            try {
                this.remove(name);
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error((Object)("Could not remove mbean: " + name), e);
            }
        }
        log.debug((Object)("Stopped " + serviceCounter + " services"));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.creator = new ServiceCreator(server);
        this.configurator = new ServiceConfigurator(server, this, this.creator);
        ServiceContext sc = this.createServiceContext(name);
        sc.state = 3;
        log.debug((Object)"Controller MBean online");
        return name == null ? OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            log.info((Object)"Registration of ServiceController failed");
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.nameToServiceMap.clear();
        this.installedServices.clear();
        this.creator.shutdown();
        this.creator = null;
        this.configurator = null;
        this.server = null;
    }

    synchronized ServiceContext createServiceContext(ObjectName objectName) {
        if (this.nameToServiceMap.containsKey(objectName)) {
            return (ServiceContext)this.nameToServiceMap.get(objectName);
        }
        ServiceContext ctx = new ServiceContext();
        ctx.objectName = objectName;
        this.nameToServiceMap.put(objectName, ctx);
        return ctx;
    }

    void registerDependency(ObjectName needs, ObjectName used) {
        log.debug((Object)("recording that " + needs + " depends on " + used));
        ServiceContext needsCtx = this.createServiceContext(needs);
        ServiceContext usedCtx = this.createServiceContext(used);
        if (!needsCtx.iDependOn.contains(usedCtx)) {
            needsCtx.iDependOn.add(usedCtx);
            usedCtx.dependsOnMe.add(needsCtx);
        }
    }

    private void register(ServiceContext ctx, Collection depends) throws Exception {
        if (!this.installedServices.contains(ctx)) {
            this.installedServices.add(ctx);
        }
        if (depends != null) {
            log.debug((Object)("adding depends in ServiceController.register: " + depends));
            Iterator i = depends.iterator();
            while (i.hasNext()) {
                this.registerDependency(ctx.objectName, (ObjectName)i.next());
            }
        }
        if (ctx.proxy == null) {
            ctx.proxy = this.getServiceProxy(ctx.objectName, null);
        }
    }

    private Service getServiceProxy(ObjectName objectName, String serviceFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JMException {
        Service service = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (serviceFactory != null && serviceFactory.length() > 0) {
            Class<?> clazz = loader.loadClass(serviceFactory);
            ServiceFactory factory = (ServiceFactory)clazz.newInstance();
            service = factory.createService(this.server, objectName);
        } else {
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{Service.class};
            ServiceProxy handler = new ServiceProxy(objectName, opInfo);
            service = (Service)Proxy.newProxyInstance(Service.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return service;
    }

    private void sendControllerNotification(String type, ObjectName serviceName) {
        Notification notification = new Notification(type, this, super.nextNotificationSequenceNumber());
        notification.setUserData(serviceName);
        this.sendNotification(notification);
    }

    static {
        serviceOpMap.put("create", new Integer(0));
        serviceOpMap.put("start", new Integer(1));
        serviceOpMap.put("destroy", new Integer(2));
        serviceOpMap.put("stop", new Integer(3));
    }

    public class ServiceProxy
    implements InvocationHandler {
        private boolean[] hasOp = new boolean[]{false, false, false, false};
        private ObjectName objectName;
        private boolean hasJBossInternalLifecycle;

        public ServiceProxy(ObjectName objectName, MBeanOperationInfo[] opInfo) {
            this.objectName = objectName;
            for (int op = 0; op < opInfo.length; ++op) {
                MBeanOperationInfo info = opInfo[op];
                String name = info.getName();
                if (name.equals(ServiceController.JBOSS_INTERNAL_LIFECYCLE)) {
                    this.hasJBossInternalLifecycle = true;
                    continue;
                }
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID == null || !info.getReturnType().equals("void") || info.getSignature().length != 0) continue;
                this.hasOp[opID.intValue()] = true;
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (this.hasJBossInternalLifecycle) {
                try {
                    ServiceController.this.server.invoke(this.objectName, ServiceController.JBOSS_INTERNAL_LIFECYCLE, new Object[]{name}, JBOSS_INTERNAL_LIFECYCLE_SIG);
                    return null;
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            Integer opID = (Integer)serviceOpMap.get(name);
            if (opID != null && this.hasOp[opID]) {
                try {
                    String[] sig = new String[]{};
                    ServiceController.this.server.invoke(this.objectName, name, args, sig);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            return null;
        }
    }
}

