/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Rectangle;

public class SelectedArea {
    private static final String FULL_MOVING_AREA_CSS_CLASS = "thumbnailMovingSelectedArea";
    private static final String INNER_MOVING_AREA_CSS_CLASS = "thumbnailInnerMovingSelectedArea";
    private static final String FULL_AREA_CSS_CLASS = "thumbnailSelectedArea";
    private static final String INNER_AREA_CSS_CLASS = "thumbnailInnerSelectedArea";
    private int maxWidth;
    private int maxHeight;
    private Rectangle area;
    private final SimplePanel fullMovingArea = new SimplePanel();
    private final SimplePanel innerMovingArea = new SimplePanel();
    private final SimplePanel fullArea = new SimplePanel();
    private final SimplePanel innerArea = new SimplePanel();

    public SelectedArea(int maxWidth, int maxHeight, Panel parent) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.createAreas();
        parent.add((Widget)this.fullArea);
        parent.add((Widget)this.innerArea);
        parent.add((Widget)this.fullMovingArea);
        parent.add((Widget)this.innerMovingArea);
    }

    private void createAreas() {
        this.fullMovingArea.setStyleName(FULL_MOVING_AREA_CSS_CLASS);
        this.setDefaultStyleAttributes((Widget)this.fullMovingArea);
        this.innerMovingArea.setStyleName(INNER_MOVING_AREA_CSS_CLASS);
        this.setDefaultStyleAttributes((Widget)this.innerMovingArea);
        this.fullArea.setStyleName(FULL_AREA_CSS_CLASS);
        this.setDefaultStyleAttributes((Widget)this.fullArea);
        this.innerArea.setStyleName(INNER_AREA_CSS_CLASS);
        this.setDefaultStyleAttributes((Widget)this.innerArea);
    }

    private void setDefaultStyleAttributes(Widget w) {
        Element element = w.getElement();
        DOM.setStyleAttribute((Element)element, (String)"display", (String)"block");
        DOM.setStyleAttribute((Element)element, (String)"position", (String)"absolute");
    }

    public void changeArea(Rectangle area) {
        this.area = area;
        this.drawArea();
    }

    public Rectangle getCurrentArea() {
        return this.area;
    }

    public void move(int x, int y) {
        this.area.move(x, y);
        this.ensureValidArea();
        this.drawArea();
    }

    public void centerOn(int x, int y) {
        this.area.centerOn(x, y);
        this.ensureValidArea();
        this.drawArea();
    }

    public void putArea() {
        this.updateAreaStyles((Widget)this.fullArea, this.area.getTopLeft().getX(), this.area.getTopLeft().getY(), this.area.getWidth(), this.area.getHeight());
        this.updateAreaStyles((Widget)this.innerArea, this.area.getTopLeft().getX(), this.area.getTopLeft().getY(), this.area.getWidth(), this.area.getHeight());
    }

    private void ensureValidArea() {
        int newX = this.area.getTopLeft().getX();
        int newY = this.area.getTopLeft().getY();
        if (newX + this.fullMovingArea.getOffsetWidth() > this.maxWidth) {
            newX = this.maxWidth - this.fullMovingArea.getOffsetWidth();
        } else if (newX < 0) {
            newX = 0;
        }
        if (newY + this.fullMovingArea.getOffsetHeight() > this.maxHeight) {
            newY = this.maxHeight - this.fullMovingArea.getOffsetHeight();
        } else if (newY < 0) {
            newY = 0;
        }
        this.area.setLocation(newX, newY);
    }

    private void drawArea() {
        this.updateAreaStyles((Widget)this.fullMovingArea, this.area.getTopLeft().getX(), this.area.getTopLeft().getY(), this.area.getWidth(), this.area.getHeight());
        this.updateAreaStyles((Widget)this.innerMovingArea, this.area.getTopLeft().getX(), this.area.getTopLeft().getY(), this.area.getWidth(), this.area.getHeight());
    }

    private void updateAreaStyles(Widget w, int left, int top, int width, int height) {
        Element element = w.getElement();
        DOM.setStyleAttribute((Element)element, (String)"left", (String)("" + left + "px"));
        DOM.setStyleAttribute((Element)element, (String)"top", (String)("" + top + "px"));
        DOM.setStyleAttribute((Element)element, (String)"width", (String)("" + width + "px"));
        DOM.setStyleAttribute((Element)element, (String)"height", (String)("" + height + "px"));
    }
}

