/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.collections.BeanMap;
import org.apache.jackrabbit.core.config.ConfigurationException;

public class BeanConfig {
    private static ClassLoader DEFAULT_CLASS_LOADER = BeanConfig.class.getClassLoader();
    private ClassLoader classLoader = BeanConfig.getDefaultClassLoader();
    private final String className;
    private final Properties properties;

    public BeanConfig(String className, Properties properties) {
        this.className = className;
        this.properties = (Properties)properties.clone();
    }

    public BeanConfig(BeanConfig config) {
        this(config.getClassName(), config.getParameters());
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getParameters() {
        return this.properties;
    }

    public Object newInstance() throws ConfigurationException {
        try {
            Class<?> objectClass = Class.forName(this.getClassName(), true, this.getClassLoader());
            Object object = objectClass.newInstance();
            BeanMap map = new BeanMap(object);
            Iterator iterator = map.keyIterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String value = this.properties.getProperty(name);
                if (value == null) continue;
                map.put((Object)name, (Object)this.properties.getProperty(name));
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " was not found.", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " can not be instantiated.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " is protected.", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        return DEFAULT_CLASS_LOADER;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        DEFAULT_CLASS_LOADER = classLoader;
    }
}

