/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleFileSystem
extends DbFileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)OracleFileSystem.class);
    private Class blobClass;
    private Integer DURATION_SESSION_CONSTANT;
    private Integer MODE_READWRITE_CONSTANT;
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace;

    public OracleFileSystem() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null ? tableSpace.trim() : null;
    }

    public void init() throws FileSystemException {
        super.init();
        try {
            this.blobClass = this.con.getClass().getClassLoader().loadClass("oracle.sql.BLOB");
            this.DURATION_SESSION_CONSTANT = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
            this.MODE_READWRITE_CONSTANT = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
        }
        catch (Exception e) {
            String msg = "failed to load/introspect oracle.sql.BLOB";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws Exception {
        boolean schemaExists;
        DatabaseMetaData metaData = this.con.getMetaData();
        String tableName = this.schemaObjectPrefix + "FSENTRY";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        String userName = metaData.getUserName();
        ResultSet rs = metaData.getTables(null, userName, tableName, null);
        try {
            schemaExists = rs.next();
        }
        finally {
            rs.close();
        }
        if (!schemaExists) {
            InputStream in = OracleFileSystem.class.getResourceAsStream(this.schema + ".ddl");
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.con.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = Text.replace((String)sql, (String)"${schemaObjectPrefix}", (String)this.schemaObjectPrefix);
                        String tspace = this.tableSpace == null || "".equals(this.tableSpace) ? "" : "tablespace " + this.tableSpace;
                        sql = Text.replace((String)sql, (String)TABLE_SPACE_VARIABLE, (String)tspace).trim();
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                this.closeStream(in);
                this.closeStatement(stmt);
            }
        }
    }

    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, nvl(?, ' '), ?, null)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' ' " + "and FSENTRY_LENGTH is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' '";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  " + "and FSENTRY_NAME != ' '";
        this.selectDataSQL = "select nvl(FSENTRY_DATA, empty_blob()) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')";
        this.selectLengthSQL = "select nvl(FSENTRY_LENGTH, 0) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, ?, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null";
    }

    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    InputStream in;
                    block21: {
                        super.close();
                        in = null;
                        Blob blob = null;
                        try {
                            if (OracleFileSystem.this.isFile(filePath)) {
                                String string = OracleFileSystem.this.updateDataSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    OracleFileSystem.this.executeStmt(OracleFileSystem.this.updateDataSQL, new Object[]{blob, new Long(System.currentTimeMillis()), new Long(length), parentDir, name});
                                }
                            } else {
                                String string = OracleFileSystem.this.insertFileSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    OracleFileSystem.this.executeStmt(OracleFileSystem.this.insertFileSQL, new Object[]{parentDir, name, blob, new Long(System.currentTimeMillis()), new Long(length)});
                                }
                            }
                            if (blob == null) break block21;
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                if (blob != null) {
                                    try {
                                        OracleFileSystem.this.freeTemporaryBlob(blob);
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                tmpFile.delete();
                                throw throwable;
                            }
                        }
                        try {
                            OracleFileSystem.this.freeTemporaryBlob(blob);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    tmpFile.delete();
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessOutputStream getRandomAccessOutputStream(final String filePath) throws FileSystemException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            if (this.isFile(filePath)) {
                InputStream in = this.getInputStream(filePath);
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    int read;
                    byte[] ba = new byte[8192];
                    while ((read = in.read(ba, 0, ba.length)) != -1) {
                        ((OutputStream)out).write(ba, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                    in.close();
                }
            }
            return new RandomAccessOutputStream(){
                private final RandomAccessFile raf;
                {
                    this.raf = new RandomAccessFile(tmpFile, "rw");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    InputStream in;
                    block21: {
                        this.raf.close();
                        in = null;
                        Blob blob = null;
                        try {
                            if (OracleFileSystem.this.isFile(filePath)) {
                                String string = OracleFileSystem.this.updateDataSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    OracleFileSystem.this.executeStmt(OracleFileSystem.this.updateDataSQL, new Object[]{blob, new Long(System.currentTimeMillis()), new Long(length), parentDir, name});
                                }
                            } else {
                                String string = OracleFileSystem.this.insertFileSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    OracleFileSystem.this.executeStmt(OracleFileSystem.this.insertFileSQL, new Object[]{parentDir, name, blob, new Long(System.currentTimeMillis()), new Long(length)});
                                }
                            }
                            if (blob == null) break block21;
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                if (blob != null) {
                                    try {
                                        OracleFileSystem.this.freeTemporaryBlob(blob);
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                tmpFile.delete();
                                throw throwable;
                            }
                        }
                        try {
                            OracleFileSystem.this.freeTemporaryBlob(blob);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    tmpFile.delete();
                }

                public void seek(long position) throws IOException {
                    this.raf.seek(position);
                }

                public void write(int b) throws IOException {
                    this.raf.write(b);
                }

                public void flush() {
                }

                public void write(byte[] b) throws IOException {
                    this.raf.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.raf.write(b, off, len);
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, this.con, Boolean.FALSE, this.DURATION_SESSION_CONSTANT);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.MODE_READWRITE_CONSTANT);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, null);
        try {
            int read;
            byte[] buf = new byte[8192];
            while ((read = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException ioe) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, null);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, null);
    }
}

