/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class XAVersionManager
extends AbstractVersionManager
implements EventStateCollectionFactory,
VirtualItemStateProvider,
InternalXAResource {
    private static final String CHANGE_LOG_ATTRIBUTE_NAME = "XAVersionManager.ChangeLog";
    private static final String ITEMS_ATTRIBUTE_NAME = "VersionItems";
    private final VersionManagerImpl vMgr;
    private SessionImpl session;
    private Map xaItems;
    private boolean vmgrLocked = false;

    public XAVersionManager(VersionManagerImpl vMgr, NodeTypeRegistry ntReg, SessionImpl session, ItemStateCacheFactory cacheFactory) throws RepositoryException {
        super(ntReg);
        NodeState state;
        this.vMgr = vMgr;
        this.session = session;
        this.stateMgr = new XAItemStateManager(vMgr.getSharedStateMgr(), this, CHANGE_LOG_ATTRIBUTE_NAME, cacheFactory);
        try {
            state = (NodeState)this.stateMgr.getItemState(vMgr.getHistoryRootId());
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to retrieve history root", (Throwable)((Object)e));
        }
        this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, state, NameConstants.JCR_VERSIONSTORAGE);
    }

    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return this.vMgr.getEscFactory().createEventStateCollection(this.session);
    }

    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this;
    }

    public VersionHistory createVersionHistory(Session session, NodeState node) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistory history = this.createVersionHistory(node);
            this.xaItems.put(history.getId(), history);
            return (VersionHistory)((SessionImpl)session).getNodeById(history.getId());
        }
        return this.vMgr.createVersionHistory(session, node);
    }

    public Version checkin(NodeImpl node) throws RepositoryException {
        if (this.isInXA()) {
            String histUUID = node.getProperty(NameConstants.JCR_VERSIONHISTORY).getString();
            InternalVersion version = this.checkin((InternalVersionHistoryImpl)this.getVersionHistory(NodeId.valueOf(histUUID)), node);
            return (Version)((SessionImpl)node.getSession()).getNodeById(version.getId());
        }
        return this.vMgr.checkin(node);
    }

    public void removeVersion(VersionHistory history, Name versionName) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((VersionHistoryImpl)history).getInternalVersionHistory();
            this.removeVersion(vh, versionName);
            return;
        }
        this.vMgr.removeVersion(history, versionName);
    }

    public Version setVersionLabel(VersionHistory history, Name version, Name label, boolean move) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((VersionHistoryImpl)history).getInternalVersionHistory();
            InternalVersion v = this.setVersionLabel(vh, version, label, move);
            if (v == null) {
                return null;
            }
            return (Version)((SessionImpl)history.getSession()).getNodeById(v.getId());
        }
        return this.vMgr.setVersionLabel(history, version, label, move);
    }

    public void close() throws Exception {
        this.stateMgr.dispose();
    }

    public boolean isVirtualRoot(ItemId id) {
        return false;
    }

    public NodeId getVirtualRootId() {
        return null;
    }

    public VirtualPropertyState createPropertyState(VirtualNodeState parent, Name name, int type, boolean multiValued) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    public VirtualNodeState createNodeState(VirtualNodeState parent, Name name, NodeId id, Name nodeTypeName) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    public boolean setNodeReferences(NodeReferences refs) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            changeLog.modified(refs);
            return true;
        }
        return false;
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id);
        }
        throw new NoSuchItemStateException("State not in change log: " + id);
    }

    public boolean hasItemState(ItemId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.has(id);
        }
        return false;
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id);
        }
        return null;
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id) != null;
        }
        return false;
    }

    public void addListener(ItemStateListener listener) {
    }

    public void removeListener(ItemStateListener listener) {
    }

    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionItem item = null;
        if (this.xaItems != null) {
            item = (InternalVersionItem)this.xaItems.get(id);
        }
        if (item == null) {
            item = this.vMgr.getItem(id);
        }
        return item;
    }

    protected boolean hasItem(NodeId id) {
        if (this.xaItems != null && this.xaItems.containsKey(id)) {
            return true;
        }
        return this.vMgr.hasItem(id);
    }

    protected boolean hasItemReferences(InternalVersionItem item) throws RepositoryException {
        return this.session.getNodeById(item.getId()).getReferences().hasNext();
    }

    protected InternalVersion checkin(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        InternalVersion version;
        NodeId frozenNodeId;
        InternalVersionItem frozenNode;
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        if ((frozenNode = this.createInternalVersionItem(frozenNodeId = (version = super.checkin(history, node)).getFrozenNodeId())) != null) {
            this.xaItems.put(frozenNodeId, frozenNode);
        }
        return version;
    }

    protected void removeVersion(InternalVersionHistoryImpl history, Name name) throws VersionException, RepositoryException {
        if (history.getVersionManager() != this) {
            int i;
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
            InternalVersion v = history.getVersion(name);
            InternalVersion[] vs = v.getSuccessors();
            for (i = 0; i < vs.length; ++i) {
                this.xaItems.put(vs[i].getId(), vs[i]);
            }
            vs = v.getPredecessors();
            for (i = 0; i < vs.length; ++i) {
                this.xaItems.put(vs[i].getId(), vs[i]);
            }
        }
        super.removeVersion(history, name);
    }

    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, Name version, Name label, boolean move) throws RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        return super.setVersionLabel(history, version, label, move);
    }

    protected void versionCreated(InternalVersion version) {
        this.xaItems.put(version.getId(), version);
    }

    protected void versionDestroyed(InternalVersion version) {
        this.xaItems.remove(version.getId());
    }

    public void associate(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).associate(tx);
        HashMap xaItems = null;
        if (tx != null && (xaItems = (HashMap)tx.getAttribute(ITEMS_ATTRIBUTE_NAME)) == null) {
            xaItems = new HashMap();
            tx.setAttribute(ITEMS_ATTRIBUTE_NAME, xaItems);
        }
        this.xaItems = xaItems;
    }

    public void beforeOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).beforeOperation(tx);
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).prepare(tx);
        }
    }

    public void commit(TransactionContext tx) throws TransactionException {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).commit(tx);
            Map xaItems = (Map)tx.getAttribute(ITEMS_ATTRIBUTE_NAME);
            this.vMgr.itemsUpdated(xaItems.values());
        }
    }

    public void rollback(TransactionContext tx) {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).rollback(tx);
        }
    }

    public void afterOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).afterOperation(tx);
    }

    public InternalXAResource getXAResourceBegin() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
                Map vItems = (Map)tx.getAttribute(XAVersionManager.ITEMS_ATTRIBUTE_NAME);
                if (!vItems.isEmpty()) {
                    XAVersionManager.this.vMgr.acquireWriteLock();
                    XAVersionManager.this.vMgr.getSharedStateMgr().setNoLockHack(true);
                    XAVersionManager.this.vmgrLocked = true;
                }
            }

            public void commit(TransactionContext tx) {
            }

            public void rollback(TransactionContext tx) {
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }

    public InternalXAResource getXAResourceEnd() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
            }

            public void commit(TransactionContext tx) {
                this.internalReleaseWriteLock();
            }

            public void rollback(TransactionContext tx) {
                this.internalReleaseWriteLock();
            }

            public void afterOperation(TransactionContext tx) {
            }

            private void internalReleaseWriteLock() {
                if (XAVersionManager.this.vmgrLocked) {
                    XAVersionManager.this.vMgr.getSharedStateMgr().setNoLockHack(false);
                    XAVersionManager.this.vMgr.releaseWriteLock();
                    XAVersionManager.this.vmgrLocked = false;
                }
            }
        };
    }

    private boolean isInXA() {
        return this.xaItems != null;
    }

    private InternalVersionHistoryImpl makeLocalCopy(InternalVersionHistoryImpl history) throws RepositoryException {
        this.acquireReadLock();
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(history.getId());
            NodeStateEx stateEx = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
            InternalVersionHistoryImpl internalVersionHistoryImpl = new InternalVersionHistoryImpl(this, stateEx);
            return internalVersionHistoryImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to make local copy", (Throwable)((Object)e));
        }
        finally {
            this.releaseReadLock();
        }
    }

    boolean differentXAEnv(InternalVersionItemImpl item) {
        return item.getVersionManager() == this && (this.xaItems == null || !this.xaItems.containsKey(item.getId()));
    }
}

