/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ExtensionImpl;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class ComponentInstanceImpl
implements ComponentInstance {
    private static final Log log = LogFactory.getLog(ComponentInstanceImpl.class);
    protected Object instance;
    protected RegistrationInfoImpl ri;

    public ComponentInstanceImpl(RegistrationInfoImpl ri) throws Exception {
        this.ri = ri;
        this.instance = ri.implementation == null ? this : this.ri.context.loadClass(this.ri.implementation).newInstance();
    }

    @Override
    public Object getInstance() {
        switch (this.ri.state) {
            case 2: {
                try {
                    this.ri.activate();
                    return this.instance;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    Framework.handleDevError(e);
                    return null;
                }
            }
            case 3: {
                return this.instance;
            }
        }
        return null;
    }

    public void create() throws Exception {
        this.instance = this.ri.implementation == null ? this : this.ri.context.loadClass(this.ri.implementation).newInstance();
    }

    @Override
    public void destroy() throws Exception {
        this.deactivate();
        this.instance = null;
        this.ri = null;
    }

    @Override
    public RuntimeContext getContext() {
        return this.ri.context;
    }

    @Override
    public ComponentName getName() {
        return this.ri.name;
    }

    @Override
    public void activate() throws Exception {
        try {
            if (this.instance instanceof Component) {
                ((Component)this.instance).activate(this);
            } else {
                Method meth = this.instance.getClass().getDeclaredMethod("activate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.error((Object)("Failed to activate component: " + this.getName()), (Throwable)e);
            Framework.handleDevError(e);
        }
    }

    @Override
    public void deactivate() throws Exception {
        try {
            if (this.instance instanceof Component) {
                ((Component)this.instance).deactivate(this);
            } else {
                Method meth = this.instance.getClass().getDeclaredMethod("deactivate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.error((Object)("Failed to deactivate component: " + this.getName()), (Throwable)e);
            Framework.handleDevError(e);
        }
    }

    @Override
    public void registerExtension(Extension extension) throws Exception {
        ExtensionPointImpl xp = this.ri.getExtensionPoint(extension.getExtensionPoint());
        if (xp != null) {
            String superCo = xp.getSuperComponent();
            if (superCo != null) {
                ((ExtensionImpl)extension).target = new ComponentName(superCo);
                this.ri.manager.registerExtension(extension);
                return;
            }
        } else {
            log.error((Object)("Warning: target extension point '" + extension.getExtensionPoint() + "' of '" + extension.getTargetComponent().getName() + "' is unknown. Check your extension in component " + extension.getComponent().getName()));
            Framework.handleDevError(null);
        }
        if (this.instance instanceof Component) {
            ((Component)this.instance).registerExtension(extension);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("registerExtension", Extension.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, extension);
            }
            catch (Exception e) {
                Framework.handleDevError(e);
            }
        }
    }

    @Override
    public void unregisterExtension(Extension extension) throws Exception {
        if (this.instance instanceof Component) {
            ((Component)this.instance).unregisterExtension(extension);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("unregisterExtension", Extension.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, extension);
            }
            catch (Exception e) {
                Framework.handleDevError(e);
            }
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object object = this.getInstance();
        if (object instanceof Adaptable) {
            return ((Adaptable)object).getAdapter(adapter);
        }
        if (adapter.isAssignableFrom(object.getClass())) {
            return adapter.cast(object);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> set = this.ri.getProperties().keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Property getProperty(String property) {
        return this.ri.getProperties().get(property);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ri.getContext();
    }

    @Override
    public Object getPropertyValue(String property) {
        return this.getPropertyValue(property, null);
    }

    @Override
    public Object getPropertyValue(String property, Object defValue) {
        Property prop = this.getProperty(property);
        if (prop != null) {
            return prop.getValue();
        }
        return defValue;
    }

    @Override
    public String[] getProvidedServiceNames() {
        return this.ri.getProvidedServiceNames();
    }

    public String toString() {
        if (this.ri == null) {
            return super.toString();
        }
        return this.ri.toString();
    }
}

