/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class DownloadServlet
extends HttpServlet {
    protected static final int BUFFER_SIZE = 524288;
    private static final long serialVersionUID = 986876871L;
    public static final Log log = LogFactory.getLog(DownloadServlet.class);

    private static CoreSession getCoreSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = rm.getRepository(repoName);
        if (repo == null) {
            throw new ClientException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e1) {
            requestURI = req.getRequestURI();
        }
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/nxbigfile/", "");
        String[] pathParts = filePath.split("/");
        String repoName = pathParts[0];
        String docId = pathParts[1];
        String fieldPath = pathParts[2];
        String fileName = pathParts[3];
        String completePath = filePath.split(docId)[1];
        int idx = completePath.lastIndexOf(47);
        if (idx > 0) {
            fieldPath = completePath.substring(0, idx);
            fileName = completePath.substring(idx + 1);
        }
        CoreSession session = null;
        InputStream in = null;
        try {
            int read;
            Blob blob;
            session = DownloadServlet.getCoreSession(repoName);
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            if (fieldPath != null) {
                if ((fieldPath = fieldPath.replace(';', ':')).startsWith("/blobholder")) {
                    BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
                    if (bh == null) {
                        return;
                    }
                    String bhPath = fieldPath.replace("/blobholder:", "");
                    if ("".equals(bhPath) || "0".equals(bhPath)) {
                        blob = bh.getBlob();
                    } else {
                        int idxbh = Integer.parseInt(bhPath);
                        blob = (Blob)bh.getBlobs().get(idxbh);
                    }
                } else {
                    blob = (Blob)DocumentModelUtils.getPropertyValue((DocumentModel)doc, (String)DocumentModelUtils.decodePropertyName((String)fieldPath));
                    if (blob == null) {
                        blob = (Blob)DocumentModelUtils.getComplexPropertyValue((DocumentModel)doc, (String)fieldPath);
                    }
                }
            } else {
                return;
            }
            if (fileName == null || fileName.length() == 0) {
                fileName = blob.getFilename() != null && blob.getFilename().length() > 0 ? blob.getFilename() : "file";
            }
            boolean inline = req.getParameter("inline") != null;
            String userAgent = req.getHeader("User-Agent");
            String contentDisposition = RFC2231.encodeContentDisposition((String)fileName, (boolean)inline, (String)userAgent);
            resp.setHeader("Content-Disposition", contentDisposition);
            resp.setContentType(blob.getMimeType());
            long fileSize = blob.getLength();
            if (fileSize > 0L) {
                resp.setContentLength((int)fileSize);
            }
            ServletOutputStream out = resp.getOutputStream();
            in = blob.getStream();
            byte[] buffer = new byte[524288];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                out.flush();
            }
        }
        catch (IOException ioe) {
            this.handleClientDisconnect(ioe);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (resp != null) {
                try {
                    resp.flushBuffer();
                }
                catch (IOException ioe) {
                    this.handleClientDisconnect(ioe);
                }
            }
            if (session != null) {
                CoreInstance.getInstance().close(session);
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public void handleClientDisconnect(IOException ioe) throws IOException {
        if (!"ClientAbortException".equals(ioe.getClass().getSimpleName())) {
            throw ioe;
        }
        log.debug((Object)ioe, (Throwable)ioe);
    }
}

