/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.ListTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeBindingException;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDLoader {
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final Log log = LogFactory.getLog(XSDLoader.class);
    private final SchemaManagerImpl typeManager;
    private XSOMParser parser;

    public XSDLoader(SchemaManagerImpl typeManager) {
        this.typeManager = typeManager;
    }

    protected void initParser() {
        this.parser = new XSOMParser();
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        this.parser.setErrorHandler((ErrorHandler)errorHandler);
        this.parser.setEntityResolver((EntityResolver)new CustomEntityResolver());
    }

    public static XSSchema getUserSchema(XSSchemaSet schemaSet) {
        Collection schemas = schemaSet.getSchemas();
        for (XSSchema schema : schemas) {
            String ns = schema.getTargetNamespace();
            if (ns.length() <= 0 || ns.equals(NS_XSD)) continue;
            return schema;
        }
        return null;
    }

    public Schema loadSchema(String name, String prefix, File file, boolean override) throws SAXException, IOException, TypeException {
        XSSchema schema;
        this.initParser();
        String systemId = file.toURI().toURL().toExternalForm();
        if (file.getPath().startsWith("\\\\")) {
            systemId = systemId.replace("file://", "file:////");
        }
        this.parser.parse(systemId);
        XSSchemaSet schemaSet = this.parser.getResult();
        if (schemaSet != null && (schema = XSDLoader.getUserSchema(schemaSet)) != null) {
            return this.loadSchema(name, prefix, schema, override);
        }
        return null;
    }

    public Schema loadSchema(String name, String prefix, URL url) throws SAXException, TypeException {
        XSSchema schema;
        this.initParser();
        this.parser.parse(url);
        XSSchemaSet schemaSet = this.parser.getResult();
        if (schemaSet != null && (schema = XSDLoader.getUserSchema(schemaSet)) != null) {
            return this.loadSchema(name, prefix, schema, false);
        }
        return null;
    }

    public Schema loadSchema(String name, String prefix, InputStream in) throws SAXException, TypeException {
        XSSchema schema;
        this.initParser();
        this.parser.parse(in);
        XSSchemaSet schemaSet = this.parser.getResult();
        if (schemaSet != null && (schema = XSDLoader.getUserSchema(schemaSet)) != null) {
            return this.loadSchema(name, prefix, schema, false);
        }
        return null;
    }

    public Schema loadSchema(String name, String prefix, XSSchema schema, boolean override) throws TypeException {
        String ns = schema.getTargetNamespace();
        try {
            Schema ecmSchema = this.typeManager.getSchema(name);
            if (ecmSchema != null) {
                log.warn((Object)("Schema " + ns + " is already registered"));
                if (!override) {
                    return ecmSchema;
                }
            }
            ecmSchema = new SchemaImpl(name, new Namespace(ns, prefix));
            Collection elements = schema.getElementDecls().values();
            for (XSElementDecl el : elements) {
                Type ecmType = this.loadType(ecmSchema, el.getType());
                if (ecmType != null) {
                    XSDLoader.createField((ComplexType)ecmSchema, el, ecmType);
                    continue;
                }
                log.warn((Object)("Failed to load field " + el.getName() + " : " + el.getType()));
            }
            this.typeManager.registerSchema(ecmSchema);
            return ecmSchema;
        }
        catch (TypeBindingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TypeException("Failed to load XSD schema " + ns, t);
        }
    }

    public Type loadType(Schema schema, XSType type) throws TypeBindingException {
        Type ecmType;
        String name;
        if (type.getName() == null || type.isLocal()) {
            name = XSDLoader.getAnonymousTypeName(type);
            if (name == null) {
                log.warn((Object)"Unable to load type - no name found");
                return null;
            }
        } else {
            name = type.getName();
        }
        if ((ecmType = this.typeManager.getType(name)) != null) {
            return ecmType;
        }
        ecmType = schema.getType(name);
        if (ecmType != null) {
            return ecmType;
        }
        if (type.getTargetNamespace().equals(NS_XSD)) {
            ecmType = XSDTypes.getType(name);
            this.typeManager.registerType(ecmType);
            return ecmType;
        }
        ecmType = type.isSimpleType() ? (type instanceof XSListSimpleType ? this.loadListType(schema, (XSListSimpleType)type) : this.loadSimpleType(schema, type)) : this.loadComplexType(schema, name, (XSType)type.asComplexType());
        if (ecmType != null) {
            schema.registerType(ecmType);
        }
        return ecmType;
    }

    public Type loadLocalType(XSType xsType) {
        return null;
    }

    private Type loadComplexType(Schema schema, String name, XSType type) throws TypeBindingException {
        Type ret;
        XSComplexType xsct;
        XSContentType content;
        XSType baseType = type.getBaseType();
        ComplexType superType = null;
        if (baseType.getBaseType() != baseType) {
            if (baseType.isComplexType()) {
                superType = (ComplexType)this.loadType(schema, baseType);
            } else {
                log.warn((Object)"Complex type has a non complex type super type???");
            }
        }
        if ((content = (xsct = type.asComplexType()).getExplicitContent()) == null) {
            content = xsct.getContentType();
        }
        if ((ret = this.createComplexType(schema, superType, name, content)) instanceof ComplexType) {
            this.loadAttributes(schema, xsct, (ComplexType)ret);
        }
        return ret;
    }

    private void loadAttributes(Schema schema, XSComplexType xsct, ComplexType ct) throws TypeBindingException {
        Collection attrs = xsct.getAttributeUses();
        for (XSAttributeUse attr : attrs) {
            XSAttributeDecl at = attr.getDecl();
            Type fieldType = this.loadType(schema, (XSType)at.getType());
            if (fieldType == null) {
                throw new TypeBindingException("Cannot add type for '" + at.getName() + "'");
            }
            XSDLoader.createField(ct, at, fieldType);
        }
    }

    private SimpleType loadSimpleType(Schema schema, XSType type) throws TypeBindingException {
        String name = type.getName();
        if (name == null) {
            return null;
        }
        XSType baseType = type.getBaseType();
        SimpleType superType = null;
        if (baseType != type) {
            superType = (SimpleType)this.loadType(schema, baseType);
        }
        return new SimpleTypeImpl(superType, schema.getName(), name);
    }

    private ListType loadListType(Schema schema, XSListSimpleType type) {
        String name = type.getName();
        if (name == null) {
            return null;
        }
        XSSimpleType xsItemType = type.getItemType();
        Type itemType = xsItemType.getTargetNamespace().equals(NS_XSD) ? XSDTypes.getType(xsItemType.getName()) : this.typeManager.getType(xsItemType.getName());
        if (itemType == null) {
            log.error((Object)"list item type was not defined -> you should define first the item type");
            return null;
        }
        return new ListTypeImpl(schema.getName(), name, itemType);
    }

    private Type createComplexType(Schema schema, ComplexType superType, String name, XSContentType content) throws TypeBindingException {
        ComplexTypeImpl ct = new ComplexTypeImpl(superType, schema.getName(), name);
        schema.registerType(ct);
        XSParticle particle = content.asParticle();
        if (particle == null) {
            return ct;
        }
        XSTerm term = particle.getTerm();
        XSModelGroup mg = term.asModelGroup();
        if (mg == null) {
            throw new TypeBindingException("unsupported complex type");
        }
        XSParticle[] group = mg.getChildren();
        if (group.length == 1 && superType == null && group[0].isRepeated()) {
            return this.createListType(schema, name, group[0]);
        }
        for (XSParticle child : group) {
            term = child.getTerm();
            XSElementDecl element = term.asElementDecl();
            if (element == null) {
                log.warn((Object)("Ignoring " + name + " unsupported complex type"));
                return null;
            }
            this.loadComplexTypeElement(schema, ct, element);
        }
        return ct;
    }

    public ListType createListType(Schema schema, String name, XSParticle particle) throws TypeBindingException {
        XSElementDecl element = particle.getTerm().asElementDecl();
        if (element == null) {
            log.warn((Object)("Ignoring " + name + " unsupported list type"));
            return null;
        }
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        Type type = this.loadType(schema, element.getType());
        return new ListTypeImpl(schema.getName(), name, type, element.getName(), defValue, particle.getMinOccurs(), particle.getMaxOccurs());
    }

    private void loadComplexTypeElement(Schema schema, ComplexType type, XSElementDecl element) throws TypeBindingException {
        XSType elementType = element.getType();
        Type fieldType = this.loadType(schema, elementType);
        if (fieldType != null) {
            XSDLoader.createField(type, element, fieldType);
        }
    }

    private static Field createField(ComplexType type, XSElementDecl element, Type fieldType) {
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        if (element.isNillable()) {
            flags |= 1;
        }
        return type.addField(elementName, fieldType.getRef(), defValue, flags);
    }

    private static Field createField(ComplexType type, XSAttributeDecl element, Type fieldType) {
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        return type.addField(elementName, fieldType.getRef(), defValue, flags);
    }

    private static String getAnonymousTypeName(XSType type) {
        if (type.isComplexType()) {
            XSElementDecl container = type.asComplexType().getScope();
            String elName = container.getName();
            return elName + "#anonymousType";
        }
        return null;
    }

    class CustomEntityResolver
    implements EntityResolver {
        CustomEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url;
            if (systemId != null && (url = XSDLoader.this.typeManager.resolveSchemaLocation(systemId)) != null) {
                InputSource is = new InputSource(url.openStream());
                is.setPublicId(publicId);
                return is;
            }
            return null;
        }
    }

    static class SchemaErrorHandler
    implements ErrorHandler {
        SchemaErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            log.error((Object)("Error: " + exception.getMessage()));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            log.error((Object)("FatalError: " + exception.getMessage()));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            log.error((Object)("Warning: " + exception.getMessage()));
        }
    }
}

