/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.util.Set;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.webapp.seam.SeamHotReloadHelper;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class NuxeoSeamHotReloadRestTrigger
extends BaseStatelessNuxeoRestlet {
    protected void doHandleStatelessRequest(Request req, Response res) {
        StringBuffer sb = new StringBuffer();
        if (!SeamHotReloadHelper.isHotReloadEnabled()) {
            sb.append("This operation is not permited");
        } else {
            long t0 = System.currentTimeMillis();
            Set<String> reloadedComponents = SeamHotReloadHelper.reloadSeamComponents(NuxeoSeamHotReloadRestTrigger.getHttpRequest((Request)req));
            long t1 = System.currentTimeMillis();
            if (reloadedComponents != null) {
                sb.append("Reloaded ");
                sb.append(reloadedComponents.size());
                sb.append(" Seam components in ");
                sb.append(t1 - t0);
                sb.append("ms");
                sb.append("\n");
                for (String cn : reloadedComponents) {
                    sb.append("  ");
                    sb.append(cn);
                    sb.append("\n");
                }
            } else {
                Set<String> reloadableComponents = SeamHotReloadHelper.getHotDeployableComponents(NuxeoSeamHotReloadRestTrigger.getHttpRequest((Request)req));
                if (reloadableComponents == null || reloadableComponents.size() == 0) {
                    sb.append("Nothing to reload");
                } else {
                    sb.append(reloadableComponents.size());
                    sb.append(" reloadable Seam Components\n");
                    sb.append("But nothing to reload (classes are up to date)");
                }
            }
        }
        res.setEntity(sb.toString(), MediaType.TEXT_PLAIN);
    }
}

