/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.web.Session;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.security.UserManagerActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="userManagerActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UserManagerActionsBean
implements UserManagerActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagerActionsBean.class);
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected Principal currentUser;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected Map<String, DocumentModelList> userCatalog;
    @DataModel(value="userList")
    protected DocumentModelList users;
    @DataModelSelection(value="userList")
    protected DocumentModel selectedUser;
    protected String userListingMode;
    protected DocumentModel newUser;
    protected DocumentModel searchUserModel;
    protected String searchString = "";
    @RequestParameter(value="newSelectedLetter")
    protected String newSelectedLetter;
    protected String selectedLetter;
    protected boolean searchOverflow = false;

    @Override
    public String getUserListingMode() throws ClientException {
        if (this.userListingMode == null) {
            this.userListingMode = this.userManager.getUserListingMode();
        }
        return this.userListingMode;
    }

    @Override
    @Factory(value="userList")
    public DocumentModelList getUsers() throws ClientException {
        if (this.users == null) {
            this.searchOverflow = false;
            try {
                String userListingMode = this.getUserListingMode();
                if ("search_only".equals(userListingMode) || !StringUtils.isEmpty((String)this.getTrimmedSearchString())) {
                    if ("*".equals(this.getTrimmedSearchString())) {
                        this.users = this.userManager.searchUsers(null);
                    } else if (!StringUtils.isEmpty((String)this.getTrimmedSearchString())) {
                        this.users = this.userManager.searchUsers(this.getTrimmedSearchString());
                    }
                } else if ("tabbed".equals(userListingMode)) {
                    Collection<String> catalogLetters;
                    if (this.userCatalog == null) {
                        this.updateUserCatalog();
                    }
                    if (!(!StringUtils.isEmpty((String)this.selectedLetter) && this.userCatalog.containsKey(this.selectedLetter) || (catalogLetters = this.getCatalogLetters()).isEmpty())) {
                        this.selectedLetter = catalogLetters.iterator().next();
                    }
                    this.users = this.userCatalog.get(this.selectedLetter);
                }
            }
            catch (SizeLimitExceededException e) {
                this.searchOverflow = true;
            }
            catch (Exception t) {
                throw ClientException.wrap((Throwable)t);
            }
        }
        if (this.users == null) {
            this.users = new DocumentModelListImpl();
        }
        return this.users;
    }

    @Override
    public void resetUsers() {
        this.users = null;
    }

    protected void updateUserCatalog() throws ClientException {
        DocumentModelList allUsers = this.userManager.searchUsers(null);
        this.userCatalog = new HashMap<String, DocumentModelList>();
        String userSortField = this.userManager.getUserSortField();
        for (DocumentModel user : allUsers) {
            String firstLetter;
            DocumentModelList list;
            String displayName = null;
            if (userSortField != null) {
                org.nuxeo.ecm.core.api.DataModel dm = (org.nuxeo.ecm.core.api.DataModel)user.getDataModels().values().iterator().next();
                displayName = (String)dm.getData(userSortField);
            }
            if (StringUtils.isEmpty(displayName)) {
                displayName = user.getId();
            }
            if ((list = this.userCatalog.get(firstLetter = displayName.substring(0, 1).toUpperCase())) == null) {
                list = new DocumentModelListImpl();
                this.userCatalog.put(firstLetter, list);
            }
            list.add((Object)user);
        }
    }

    @Override
    public DocumentModel getSelectedUser() {
        return this.selectedUser;
    }

    protected DocumentModel refreshUser(String userName) throws ClientException {
        return this.userManager.getUserModel(userName);
    }

    protected String viewUser(DocumentModel user, boolean refresh) throws ClientException {
        if (user != null) {
            this.selectedUser = user;
            if (refresh) {
                this.selectedUser = this.refreshUser(user.getId());
            }
            if (this.selectedUser != null) {
                return "view_user";
            }
        }
        return null;
    }

    @Override
    public String viewUser() throws ClientException {
        return this.viewUser(this.selectedUser, true);
    }

    @Override
    public String viewUser(String userName) throws ClientException {
        return this.viewUser(this.userManager.getUserModel(userName), false);
    }

    @Override
    public String searchUsers() throws ClientException {
        this.searchOverflow = false;
        this.resetUsers();
        return this.viewUsers();
    }

    @Override
    public void validateUserName(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !StringUtils.containsOnly((String)((String)value), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@")) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.userManager.wrong.username"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    @Override
    public void validatePassword(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String firstPasswordInputId = (String)attributes.get("firstPasswordInputId");
        String secondPasswordInputId = (String)attributes.get("secondPasswordInputId");
        if (firstPasswordInputId == null || secondPasswordInputId == null) {
            log.error((Object)"Cannot validate passwords: input id(s) not found");
            return;
        }
        UIInput firstPasswordComp = (UIInput)component.findComponent(firstPasswordInputId);
        UIInput secondPasswordComp = (UIInput)component.findComponent(secondPasswordInputId);
        if (firstPasswordComp == null || secondPasswordComp == null) {
            log.error((Object)"Cannot validate passwords: input(s) not found");
            return;
        }
        Object firstPassword = firstPasswordComp.getLocalValue();
        Object secondPassword = secondPasswordComp.getLocalValue();
        if (firstPassword == null || secondPassword == null) {
            log.error((Object)"Cannot validate passwords: value(s) not found");
            return;
        }
        if (!firstPassword.equals(secondPassword)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.userManager.password.not.match"), null);
            throw new ValidatorException(message);
        }
    }

    @Override
    public String editUser() throws ClientException {
        this.selectedUser = this.refreshUser(this.selectedUser.getId());
        return "edit_user";
    }

    @Override
    public String deleteUser() throws ClientException {
        try {
            this.userManager.deleteUser(this.selectedUser);
            this.resetUsers();
            return this.viewUsers();
        }
        catch (Exception t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String updateUser() throws ClientException {
        try {
            this.userManager.updateUser(this.selectedUser);
            this.resetUsers();
            return this.viewUser(this.selectedUser.getId());
        }
        catch (Exception t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String changePassword() throws ClientException {
        this.updateUser();
        String message = this.resourcesAccessor.getMessages().get("label.userManager.password.changed");
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, message, new Object[0]);
        if (this.selectedUser.getId().equals(this.currentUser.getName())) {
            Session.instance().invalidate();
            return this.navigationContext.goHome();
        }
        return "view_user";
    }

    @Override
    public String createUser() throws ClientException, UserAlreadyExistsException {
        try {
            this.selectedUser = this.userManager.createUser(this.newUser);
            this.newUser = null;
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, this.resourcesAccessor.getMessages().get("info.userManager.userCreated"), new Object[0]);
            return this.viewUser();
        }
        catch (UserAlreadyExistsException e) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, this.resourcesAccessor.getMessages().get("error.userManager.userAlreadyExists"), new Object[0]);
            return null;
        }
    }

    @Override
    public DocumentModel getNewUser() throws ClientException {
        if (this.newUser == null) {
            this.newUser = this.userManager.getBareUserModel();
        }
        return this.newUser;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    protected String getTrimmedSearchString() {
        if (this.searchString == null) {
            return null;
        }
        return this.searchString.trim();
    }

    @Override
    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Override
    public Collection<String> getCatalogLetters() {
        ArrayList<String> list = new ArrayList<String>(this.userCatalog.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public void setSelectedLetter(String selectedLetter) {
        this.selectedLetter = selectedLetter;
    }

    @Override
    public String getSelectedLetter() {
        return this.selectedLetter;
    }

    @Override
    public String viewUsers() throws ClientException {
        String userListingMode;
        if (this.newSelectedLetter != null && !this.newSelectedLetter.equals(this.selectedLetter)) {
            this.selectedLetter = this.newSelectedLetter;
            this.resetUsers();
        }
        if ("tabbed".equals(userListingMode = this.getUserListingMode())) {
            return "view_many_users";
        }
        return "view_users";
    }

    protected boolean getCanEditUsers(boolean allowCurrentUser) throws ClientException {
        if (this.userManager.areUsersReadOnly().booleanValue()) {
            return false;
        }
        if (this.currentUser instanceof NuxeoPrincipal) {
            NuxeoPrincipal pal = (NuxeoPrincipal)this.currentUser;
            if (pal.isAdministrator()) {
                return true;
            }
            if (allowCurrentUser && this.selectedUser != null && pal.getName().equals(this.selectedUser.getId())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getAllowEditUser() throws ClientException {
        return this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    @Override
    public boolean getAllowChangePassword() throws ClientException {
        return this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    @Override
    public boolean getAllowCreateUser() throws ClientException {
        return this.getCanEditUsers(false);
    }

    @Override
    public boolean getAllowDeleteUser() throws ClientException {
        return this.getCanEditUsers(false) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    @Override
    public String clearSearch() throws ClientException {
        this.searchString = null;
        this.searchUserModel = null;
        return this.searchUsers();
    }

    @Override
    public boolean isSearchOverflow() {
        return this.searchOverflow;
    }

    @Override
    public DocumentModel getSearchUserModel() throws ClientException {
        if (this.searchUserModel == null) {
            this.searchUserModel = this.userManager.getBareUserModel();
        }
        return this.searchUserModel;
    }

    @Override
    public String searchUsersAdvanced() throws ClientException {
        this.searchOverflow = false;
        try {
            org.nuxeo.ecm.core.api.DataModel dm = (org.nuxeo.ecm.core.api.DataModel)this.searchUserModel.getDataModels().values().iterator().next();
            Map<String, Serializable> filter = UserManagerActionsBean.mkSerializableMap(dm.getMap());
            this.users = this.userManager.searchUsers(filter, new HashSet<String>(filter.keySet()));
        }
        catch (SizeLimitExceededException e) {
            this.searchOverflow = true;
            this.users = new DocumentModelListImpl();
            return "view_users";
        }
        return this.viewUsers();
    }

    @Override
    public String clearSearchAdvanced() throws ClientException {
        this.searchUserModel = null;
        return this.viewUsers();
    }

    protected static Map<String, Serializable> mkSerializableMap(Map<String, Object> map) {
        HashMap<String, Serializable> serializableMap = null;
        if (map != null) {
            serializableMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                serializableMap.put(key, (Serializable)map.get(key));
            }
        }
        return serializableMap;
    }

    @Override
    @Factory(value="notReadOnly", scope=ScopeType.APPLICATION)
    public boolean isNotReadOnly() {
        return !"true".equals(Framework.getProperty((String)"org.nuxeo.ecm.webapp.readonly.mode", (String)"false"));
    }

    @Override
    public List<String> getUserVirtualGroups(String userId) throws Exception {
        NuxeoPrincipal principal = this.userManager.getPrincipal(userId);
        if (principal instanceof NuxeoPrincipalImpl) {
            NuxeoPrincipalImpl user = (NuxeoPrincipalImpl)principal;
            return user.getVirtualGroups();
        }
        return null;
    }

    public void setSelectedUser(DocumentModel user) throws ClientException {
        this.selectedUser = this.refreshUser(user.getId());
    }

    public void deleteUserNoRedirect() throws ClientException {
        this.deleteUser();
        this.resetUsers();
    }

    public void createUserNoRedirect() throws ClientException {
        this.createUser();
        this.resetUsers();
    }

    public void updateUserNoRedirect() throws ClientException {
        this.updateUser();
        this.resetUsers();
    }
}

