/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.bank;

import com.sun.jersey.api.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.theme.bank.ThemeBankException;
import org.nuxeo.theme.bank.Utils;
import org.nuxeo.theme.presets.PaletteIdentifyException;
import org.nuxeo.theme.presets.PaletteParseException;
import org.nuxeo.theme.presets.PaletteParser;
import org.nuxeo.theme.resources.BankManager;
import org.nuxeo.theme.resources.BankUtils;

@WebObject(type="theme-banks")
@Produces(value={"text/html"})
public class Main
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(Main.class);
    private static final String SERVER_ID = "Nuxeo/ThemeBank-1.0";

    @GET
    public Object getIndex() {
        return this.getTemplate("index.ftl");
    }

    public boolean isAdministrator() {
        Principal principal = this.ctx.getPrincipal();
        if (principal == null) {
            return false;
        }
        return ((NuxeoPrincipal)principal).isAdministrator();
    }

    @Path(value="{bank}/manage")
    public Object getManagement(@PathParam(value="bank") String bank) {
        return this.newObject("Management", new Object[]{bank});
    }

    @GET
    @Path(value="{bank}")
    public Object displayBank(@PathParam(value="bank") String bank) {
        return this.getTemplate("index.ftl").arg("bank", (Object)bank);
    }

    @GET
    @Path(value="{bank}/view")
    public Object displayBankView(@PathParam(value="bank") String bank) {
        return this.getTemplate("bank.ftl").arg("bank", (Object)bank);
    }

    @GET
    @Path(value="{bank}/info")
    public Object getBankInfo(@PathParam(value="bank") String bank) {
        return "XXX";
    }

    @GET
    @Path(value="{bank}/status")
    public Object getBankStatus(@PathParam(value="bank") String bank) {
        return "OK";
    }

    @GET
    @Path(value="{bank}/logo")
    public Object displayBankLogo(@PathParam(value="bank") String bank) {
        File file;
        try {
            file = BankManager.getBankLogoFile((String)bank);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        if (file == null || !file.exists()) {
            return this.noPreview();
        }
        String ext = FileUtils.getFileExtension((String)this.path);
        String mimeType = this.ctx.getEngine().getMimeType(ext);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return Response.ok().entity((Object)Utils.streamFile(file)).lastModified(new Date(file.lastModified())).header("Cache-Control", (Object)"public").header("Server", (Object)SERVER_ID).type(mimeType).build();
    }

    @GET
    @Path(value="navtree")
    public Object getNavtreeView() {
        return this.getTemplate("navtree.ftl");
    }

    @GET
    @Path(value="actionbar")
    public Object getActionBarView() {
        return this.getTemplate("actionbar.ftl");
    }

    @GET
    @Path(value="banks")
    public Object getBanksView() {
        return this.getTemplate("banks.ftl");
    }

    @GET
    @Path(value="session/login")
    public Object getSessionView() {
        return this.getTemplate("session.ftl");
    }

    @GET
    @Path(value="session")
    public Object doSession() {
        Object failed = this.ctx.getProperty("failed");
        if (failed == null) {
            return this.getIndex();
        }
        return this.getSessionView();
    }

    @POST
    @Path(value="session/@@login")
    public Object login() {
        return this.getIndex();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{bank}/json/skins")
    public String listBankSkins(@PathParam(value="bank") String bankName) {
        JSONArray skins = new JSONArray();
        try {
            for (String collection : BankManager.getCollections((String)bankName)) {
                Map info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
                if (info == null) continue;
                for (Map.Entry entry : info.entrySet()) {
                    String resource = (String)entry.getKey();
                    Map value = (Map)entry.getValue();
                    Boolean isSkin = false;
                    if (value.containsKey("skin")) {
                        isSkin = (Boolean)value.get("skin");
                    }
                    if (!isSkin.booleanValue()) continue;
                    Boolean isBase = false;
                    if (value.containsKey("base")) {
                        isBase = (Boolean)value.get("base");
                    }
                    JSONObject skinMap = new JSONObject();
                    skinMap.put((Object)"bank", (Object)bankName);
                    skinMap.put((Object)"collection", (Object)collection);
                    skinMap.put((Object)"resource", (Object)resource);
                    skinMap.put((Object)"name", (Object)String.format("%s (%s)", resource.replace(".css", ""), collection));
                    skinMap.put((Object)"base", (Object)isBase);
                    skins.add((Object)skinMap);
                }
            }
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        return skins.toString();
    }

    public List<String> listSkinsInCollection(String bankName, String collection) {
        Map info;
        try {
            info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        ArrayList<String> skins = new ArrayList<String>();
        if (info != null) {
            for (Map.Entry entry : info.entrySet()) {
                String resource = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                Boolean isSkin = false;
                if (value.containsKey("skin")) {
                    isSkin = (Boolean)value.get("skin");
                }
                if (!isSkin.booleanValue()) continue;
                skins.add(resource);
            }
        }
        return skins;
    }

    @GET
    @Path(value="{bank}/{collection}/view")
    public Object getCollectionView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection) {
        return this.getTemplate("collection.ftl").arg("collection", (Object)collection).arg("bank", (Object)bank);
    }

    @GET
    @Path(value="{bank}/{collection}/{type}/info")
    public Object getPresetCollectionInfo(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="type") String typeName) {
        try {
            return BankManager.getInfoFile((String)bank, (String)collection, (String)typeName);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
    }

    @GET
    @Path(value="{bank}/{collection}/style/view")
    public Object getStyleCollectionsView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection) {
        return this.getStyleCollections(bank, collection, false);
    }

    @GET
    @Path(value="{bank}/{collection}/skin/view")
    public Object getSkinsCollectionsView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection) {
        return this.getStyleCollections(bank, collection, true);
    }

    public Object getStyleCollections(String bank, String collection, Boolean skins_only) {
        return this.getTemplate("styleCollection.ftl").arg("styles", Main.getItemsInCollection(bank, collection, "style")).arg("skins", this.listSkinsInCollection(bank, collection)).arg("collection", (Object)collection).arg("bank", (Object)bank).arg("skins_only", (Object)skins_only);
    }

    @GET
    @Produces(value={"text/css"})
    @Path(value="{bank}/{collection}/style/{resource}")
    public Response getStyle(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource) {
        File file;
        try {
            file = BankManager.getStyleFile((String)bank, (String)collection, (String)resource);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        return Response.ok().entity((Object)Utils.streamFile(file)).lastModified(new Date(file.lastModified())).header("Cache-Control", (Object)"public").header("Server", (Object)SERVER_ID).build();
    }

    @GET
    @Path(value="{bank}/{collection}/style/{resource}/{action}")
    public Object renderStyle(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource, @PathParam(value="action") String action) {
        return this.getTemplate("style.ftl").arg("content", (Object)this.getStyleContent(bank, collection, resource)).arg("bank", (Object)bank).arg("resource", (Object)resource).arg("collection", (Object)collection).arg("action", (Object)action).arg("is_skin", (Object)true);
    }

    @GET
    @Path(value="{bank}/{collection}/skin/{resource}/{action}")
    public Object renderSkin(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource, @PathParam(value="action") String action) {
        return this.getTemplate("style.ftl").arg("content", (Object)this.getStyleContent(bank, collection, resource)).arg("bank", (Object)bank).arg("resource", (Object)resource).arg("collection", (Object)collection).arg("action", (Object)action).arg("is_skin", (Object)true);
    }

    @GET
    @Path(value="{bank}/{collection}/style/{resource}/preview")
    public Object displayStylePreview(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource) {
        File file;
        try {
            file = BankManager.getStylePreviewFile((String)bank, (String)collection, (String)resource);
        }
        catch (IOException e) {
            return this.noPreview();
        }
        String ext = FileUtils.getFileExtension((String)this.path);
        String mimeType = this.ctx.getEngine().getMimeType(ext);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return Response.ok().entity((Object)Utils.streamFile(file)).lastModified(new Date(file.lastModified())).header("Cache-Control", (Object)"public").header("Server", (Object)SERVER_ID).type(mimeType).build();
    }

    public String getStyleContent(String bank, String collection, String resource) {
        String content;
        File file;
        try {
            file = BankManager.getStyleFile((String)bank, (String)collection, (String)resource);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        try {
            content = BankUtils.getFileContent((File)file);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        return content;
    }

    @GET
    @Path(value="{bank}/{collection}/preset/view")
    public Object getPresetCollectionView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection) {
        return this.getTemplate("presetCollection.ftl").arg("presets", Main.getItemsInCollection(bank, collection, "preset")).arg("collection", (Object)collection).arg("bank", (Object)bank);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{bank}/{collection}/preset/{category}")
    public Response getPreset(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="category") String category) {
        File file;
        String path = String.format("%s/%s/preset/%s", bank, collection, category);
        try {
            file = BankManager.getFile((String)path);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        String content = "";
        if (!file.exists()) {
            return Response.status((int)404).build();
        }
        StringBuilder sb = new StringBuilder();
        for (File f : file.listFiles()) {
            try {
                content = BankUtils.getFileContent((File)f);
            }
            catch (IOException e) {
                log.warn((Object)("Could not read file: " + f.getAbsolutePath()));
                continue;
            }
            content = PaletteParser.renderPaletteAsCsv((byte[])content.getBytes(), (String)f.getName());
            sb.append(content);
        }
        content = sb.toString();
        return Response.ok((Object)content).lastModified(new Date(file.lastModified())).header("Cache-Control", (Object)"public").header("Server", (Object)SERVER_ID).build();
    }

    @GET
    @Path(value="{bank}/{collection}/preset/{category}/view")
    public Object getPresetView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="category") String category) {
        File file;
        String path = String.format("%s/%s/preset/%s", bank, collection, category);
        try {
            file = BankManager.getFile((String)path);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        Properties properties = new Properties();
        for (File f : file.listFiles()) {
            String content;
            try {
                content = BankUtils.getFileContent((File)f);
            }
            catch (IOException e) {
                log.warn((Object)("Could not read file: " + f.getAbsolutePath()));
                continue;
            }
            try {
                properties.putAll((Map<?, ?>)PaletteParser.parse((byte[])content.getBytes(), (String)f.getName()));
            }
            catch (PaletteIdentifyException e) {
                log.warn((Object)("Could not identify palette type: " + f.getAbsolutePath()));
            }
            catch (PaletteParseException e) {
                log.warn((Object)("Could not parse palette: " + f.getAbsolutePath()));
            }
        }
        return this.getTemplate("preset.ftl").arg("properties", (Object)properties).arg("bank", (Object)bank).arg("collection", (Object)collection).arg("category", (Object)category);
    }

    @GET
    @Path(value="{bank}/{collection}/image/view")
    public Object getImageCollectionView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection) {
        return this.getTemplate("imageCollection.ftl").arg("images", Main.getItemsInCollection(bank, collection, "image")).arg("collection", (Object)collection).arg("bank", (Object)bank);
    }

    @GET
    @Path(value="{bank}/{collection}/image/{resource}")
    public Response getImage(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource) {
        File file;
        try {
            file = BankManager.getImageFile((String)bank, (String)collection, (String)resource);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        String ext = FileUtils.getFileExtension((String)file.getPath());
        String mimeType = this.ctx.getEngine().getMimeType(ext);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return Response.ok().entity((Object)Utils.streamFile(file)).lastModified(new Date(file.lastModified())).header("Cache-Control", (Object)"public").header("Server", (Object)SERVER_ID).type(mimeType).build();
    }

    @GET
    @Path(value="{bank}/{collection}/image/{resource}/view")
    public Object getImageView(@PathParam(value="bank") String bank, @PathParam(value="collection") String collection, @PathParam(value="resource") String resource) {
        return this.getTemplate("image.ftl").arg("bank", (Object)bank).arg("resource", (Object)resource).arg("collection", (Object)collection);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{bank}/json/images")
    public String listImages(@PathParam(value="bank") String bank) {
        try {
            return Utils.listImages(bank);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{bank}/json/collections")
    public String listCollections(@PathParam(value="bank") String bank) {
        try {
            return Utils.listCollections(bank);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="json/tree")
    public String getTree() throws IOException {
        return Utils.getNavTree();
    }

    private Object noPreview() {
        return this.redirect(this.ctx.getModulePath() + "/skin/img/no-preview.png");
    }

    public static List<String> getBankNames() {
        return BankManager.getBankNames();
    }

    public static List<String> getCollections(String bank) {
        try {
            return BankManager.getCollections((String)bank);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
    }

    public static List<String> getItemsInCollection(String bank, String collection, String typeName) {
        try {
            return BankManager.getItemsInCollection((String)bank, (String)collection, (String)typeName);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("session.ftl").arg("redirect_url", (Object)this.ctx.getUrlPath())).type("text/html").build();
        }
        if (e instanceof NotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("not_found.ftl")).type("text/html").build();
        }
        if (e instanceof WebException) {
            return Response.status((int)500).entity((Object)this.getTemplate("error.ftl").arg("stacktrace", (Object)((WebException)e).getStackTraceString())).type("text/html").build();
        }
        return super.handleError(e);
    }
}

