/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.bank;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.bank.ThemeBankException;
import org.nuxeo.theme.resources.BankManager;
import org.nuxeo.theme.resources.BankUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static List<String> listSkinsInCollection(String bankName, String collection) {
        Map info;
        try {
            info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        ArrayList<String> skins = new ArrayList<String>();
        if (info != null) {
            for (Map.Entry entry : info.entrySet()) {
                String resource = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                Boolean isSkin = false;
                if (value.containsKey("skin")) {
                    isSkin = (Boolean)value.get("skin");
                }
                if (!isSkin.booleanValue()) continue;
                skins.add(resource);
            }
        }
        return skins;
    }

    public static String listBankSkins(String bankName) {
        JSONArray skins = new JSONArray();
        try {
            for (String collection : BankManager.getCollections((String)bankName)) {
                Map info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
                if (info == null) continue;
                for (Map.Entry entry : info.entrySet()) {
                    String resource = (String)entry.getKey();
                    Map value = (Map)entry.getValue();
                    Boolean isSkin = false;
                    if (value.containsKey("skin")) {
                        isSkin = (Boolean)value.get("skin");
                    }
                    if (!isSkin.booleanValue()) continue;
                    JSONObject skinMap = new JSONObject();
                    skinMap.put((Object)"bank", (Object)bankName);
                    skinMap.put((Object)"collection", (Object)collection);
                    skinMap.put((Object)"resource", (Object)resource);
                    skinMap.put((Object)"name", (Object)String.format("%s (%s)", resource.replace(".css", ""), collection));
                    skins.add((Object)skinMap);
                }
            }
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        return skins.toString();
    }

    public static String listImages(String bank) throws IOException {
        JSONArray index = new JSONArray();
        for (String collection : BankManager.getCollections((String)bank)) {
            String path = String.format("%s/%s/image/", bank, collection);
            File file = BankManager.getFile((String)path);
            if (!file.isDirectory()) {
                throw new IOException("Expected folder: " + path);
            }
            for (File image : file.listFiles()) {
                index.add((Object)String.format("%s/%s", collection, image.getName()));
            }
        }
        return index.toString();
    }

    public static String listCollections(String bank) throws IOException {
        JSONArray index = new JSONArray();
        for (String collection : BankManager.getCollections((String)bank)) {
            index.add((Object)collection);
        }
        return index.toString();
    }

    public static String getNavTree() throws IOException {
        JSONArray tree = new JSONArray();
        for (String bankName : BankManager.getBankNames()) {
            JSONObject bankNode = new JSONObject();
            bankNode.put((Object)"state", (Object)"open");
            JSONObject bankMap = new JSONObject();
            bankMap.put((Object)"title", (Object)bankName);
            JSONObject bankAttributes = new JSONObject();
            bankAttributes.put((Object)"rel", (Object)"bank");
            bankAttributes.put((Object)"path", (Object)String.format("/%s", bankName));
            bankAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)bankName));
            bankNode.put((Object)"attributes", (Object)bankAttributes);
            bankNode.put((Object)"data", (Object)bankMap);
            JSONArray childrenNodes = new JSONArray();
            for (String collection : BankManager.getCollections((String)bankName)) {
                childrenNodes.add((Object)Utils.getNavTreeCollectionNode(bankName, collection));
            }
            bankNode.put((Object)"children", (Object)childrenNodes);
            tree.add((Object)bankNode);
        }
        return tree.toString();
    }

    private static JSONObject getNavTreeCollectionNode(String bankName, String collection) throws IOException {
        String[] TYPE_NAMES;
        JSONObject collectionNode = new JSONObject();
        JSONObject collectionMap = new JSONObject();
        collectionMap.put((Object)"title", (Object)collection);
        JSONObject collectionAttributes = new JSONObject();
        collectionAttributes.put((Object)"rel", (Object)"collection");
        collectionAttributes.put((Object)"path", (Object)String.format("/%s/%s", bankName, collection));
        collectionAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s", bankName, collection)));
        collectionNode.put((Object)"data", (Object)collectionMap);
        collectionNode.put((Object)"attributes", (Object)collectionAttributes);
        JSONArray folderTypeNodes = new JSONArray();
        for (String typeName : TYPE_NAMES = new String[]{"skin", "style", "preset", "image"}) {
            JSONObject folderTypeNode = new JSONObject();
            JSONObject folderTypeMap = new JSONObject();
            folderTypeMap.put((Object)"title", (Object)typeName);
            JSONObject folderTypeAttributes = new JSONObject();
            folderTypeAttributes.put((Object)"rel", (Object)"folder");
            folderTypeAttributes.put((Object)"path", (Object)String.format("/%s/%s/%s", bankName, collection, typeName));
            folderTypeAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s-%s", bankName, collection, typeName)));
            folderTypeNode.put((Object)"attributes", (Object)folderTypeAttributes);
            folderTypeNode.put((Object)"data", (Object)folderTypeMap);
            JSONArray items = new JSONArray();
            List<String> skins = Utils.listSkinsInCollection(bankName, collection);
            String effectiveTypeName = "skin".equals(typeName) ? "style" : typeName;
            for (String item : BankManager.getItemsInCollection((String)bankName, (String)collection, (String)effectiveTypeName)) {
                if ("skin".equals(typeName) ? !skins.contains(item) : "style".equals(typeName) && skins.contains(item)) continue;
                JSONObject itemNode = new JSONObject();
                JSONObject itemMap = new JSONObject();
                itemMap.put((Object)"title", (Object)item);
                JSONObject itemAttributes = new JSONObject();
                itemAttributes.put((Object)"rel", (Object)typeName);
                itemAttributes.put((Object)"path", (Object)String.format("/%s/%s/%s/%s", bankName, collection, typeName, item));
                itemAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s-%s-%s", bankName, collection, typeName, item)));
                itemNode.put((Object)"attributes", (Object)itemAttributes);
                itemNode.put((Object)"data", (Object)itemMap);
                items.add((Object)itemNode);
            }
            folderTypeNode.put((Object)"children", (Object)items);
            folderTypeNodes.add((Object)folderTypeNode);
        }
        collectionNode.put((Object)"children", (Object)folderTypeNodes);
        return collectionNode;
    }

    public static StreamingOutput streamFile(final File file) {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Exception e) {
                    try {
                        throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
        };
    }
}

