/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient File file;
    private final String digest;
    private final long length;
    private final String repoName;

    public Binary(File file, String digest) {
        this.file = file;
        this.digest = digest;
        this.length = file.length();
        this.repoName = null;
    }

    public Binary(File file, String digest, String repoName) {
        this.file = file;
        this.digest = digest;
        this.length = file.length();
        this.repoName = repoName;
    }

    public long getLength() {
        return this.length;
    }

    public String getDigest() {
        return this.digest;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.digest + ')';
    }

    public StreamSource getStreamSource() {
        return new FileSource(this.file);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultWriteObject();
        if (this.repoName == null) {
            oos.writeObject(this.file);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.file = this.repoName == null ? (File)ois.readObject() : this.fetchData();
    }

    protected File fetchData() {
        BinaryManager mgr = RepositoryResolver.getBinaryManager(this.repoName);
        return mgr.getBinary((String)this.digest).file;
    }
}

