/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.runtime.api.Framework;

public class BinaryTextListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(BinaryTextListener.class);
    public static final String EVENT_NAME = "event_storage_binaries_doc";
    private static final String ANY2TEXT = "any2text";
    protected final ConversionService conversionService;

    public BinaryTextListener() throws ClientException {
        try {
            this.conversionService = (ConversionService)Framework.getService(ConversionService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        if (this.conversionService == null) {
            throw new ClientException("No conversion service");
        }
    }

    public void handleEvent(EventBundle eventBundle) throws ClientException {
        if (!(eventBundle instanceof ReconnectedEventBundle)) {
            log.error((Object)("Incorrect event bundle type: " + eventBundle));
            return;
        }
        CoreSession session = null;
        ModelFulltext fulltextInfo = null;
        HashSet<Serializable> ids = new HashSet<Serializable>();
        for (Event event : eventBundle) {
            if (!event.getName().equals(EVENT_NAME)) continue;
            EventContext eventContext = event.getContext();
            fulltextInfo = this.getFulltextInfoFromEventContext(eventContext);
            ids.addAll(this.getIdsFromEventContext(eventContext));
            CoreSession s = eventContext.getCoreSession();
            if (session == null) {
                session = s;
                continue;
            }
            if (session == s) continue;
            throw new ClientException("Several CoreSessions in one EventBundle");
        }
        if (session == null) {
            if (ids.isEmpty()) {
                return;
            }
            throw new ClientException("Null CoreSession");
        }
        boolean save = false;
        BlobsExtractor extractor = new BlobsExtractor();
        for (Serializable id : ids) {
            DocumentModel doc;
            IdRef docRef = new IdRef((String)((Object)id));
            if (session.getPrincipal() == null || !session.exists((DocumentRef)docRef) || (doc = session.getDocument((DocumentRef)docRef)).isProxy()) continue;
            for (String indexName : fulltextInfo.indexNames) {
                if (!fulltextInfo.indexesAllBinary.contains(indexName) && fulltextInfo.propPathsByIndexBinary.get(indexName) == null) continue;
                extractor.setExtractorProperties(fulltextInfo.propPathsByIndexBinary.get(indexName), fulltextInfo.propPathsExcludedByIndexBinary.get(indexName), fulltextInfo.indexesAllBinary.contains(indexName));
                List blobs = extractor.getBlobs(doc);
                String text = this.blobsToText(blobs);
                try {
                    session.setDocumentSystemProp((DocumentRef)docRef, "binaryText" + this.getFulltextIndexSuffix(indexName), (Serializable)((Object)text));
                }
                catch (DocumentException e) {
                    log.error((Object)("Couldn't set fulltext on: " + id), (Throwable)e);
                }
            }
            save = true;
        }
        if (save) {
            session.save();
        }
    }

    protected Set<Serializable> getIdsFromEventContext(EventContext eventContext) {
        return (Set)eventContext.getArguments()[0];
    }

    protected ModelFulltext getFulltextInfoFromEventContext(EventContext eventContext) {
        return (ModelFulltext)eventContext.getArguments()[1];
    }

    protected String blobsToText(List<Blob> blobs) {
        LinkedList<String> strings = new LinkedList<String>();
        for (Blob blob : blobs) {
            try {
                SimpleBlobHolder bh = new SimpleBlobHolder(blob);
                BlobHolder result = this.conversionService.convert(ANY2TEXT, (BlobHolder)bh, null);
                if (result == null || (blob = result.getBlob()) == null) continue;
                String string = new String(blob.getByteArray(), "UTF-8");
                if (string.indexOf(0) >= 0) {
                    string = string.replace("\u0000", " ");
                }
                strings.add(string);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return StringUtils.join(strings, (String)" ");
    }

    public String getFulltextIndexSuffix(String indexName) {
        return indexName.equals("default") ? "" : '_' + indexName;
    }
}

