/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.query.FilterableQuery;
import org.nuxeo.ecm.core.query.Query;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.QueryResult;
import org.nuxeo.ecm.core.query.UnsupportedQueryTypeException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.security.SecurityManager;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.CollectionProperty;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLCollectionProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexListProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLContentProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentProxy;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLQueryResult;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSimpleProperty;

public class SQLSession
implements org.nuxeo.ecm.core.model.Session {
    private final Repository repository;
    private final Map<String, Serializable> context;
    private final Session session;
    private Document root;
    private final String userSessionId;
    private static final Pattern dotDigitsPattern = Pattern.compile("(.*)\\.[0-9]+$");
    protected static final Pattern ORDER_BY_PATH_ASC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s*$", 2);
    protected static final Pattern ORDER_BY_PATH_DESC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s+DESC\\s*$", 2);

    public SQLSession(Session session, Repository repository, Map<String, Serializable> context) throws DocumentException {
        Node rootNode;
        this.session = session;
        this.repository = repository;
        if (context == null) {
            context = new HashMap<String, Serializable>();
        }
        this.context = context;
        context.put("creationTime", Long.valueOf(System.currentTimeMillis()));
        try {
            rootNode = session.getRootNode();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        this.root = this.newDocument(rootNode);
        this.userSessionId = (String)((Object)context.get("SESSION_ID"));
    }

    public Document getRootDocument() {
        return this.root;
    }

    public Document getNullDocument() {
        return new SQLDocumentLive(null, null, this, true);
    }

    public XAResource getXAResource() {
        throw new RuntimeException();
    }

    public void close() throws DocumentException {
        try {
            this.session.save();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        this.dispose();
    }

    public void save() throws DocumentException {
        try {
            this.session.save();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void cancel() throws DocumentException {
    }

    public boolean isLive() {
        return this.session != null && this.session.isLive();
    }

    public void dispose() {
        try {
            this.session.close();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        this.root = null;
    }

    public long getSessionId() {
        throw new RuntimeException();
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Map<String, Serializable> getSessionContext() {
        return this.context;
    }

    public SchemaManager getTypeManager() {
        return this.repository.getTypeManager();
    }

    public SecurityManager getSecurityManager() {
        return this.repository.getNuxeoSecurityManager();
    }

    public Document getDocumentByUUID(String uuid) throws DocumentException {
        try {
            Serializable id = this.session.getModel().unHackStringId(uuid);
            Node node = this.session.getNodeById(id);
            if (node == null) {
                throw new NoSuchDocumentException(uuid);
            }
            return this.newDocument(node);
        }
        catch (StorageException e) {
            throw new DocumentException("Failed to get document by UUID", (Throwable)((Object)e));
        }
    }

    public Document resolvePath(String path) throws DocumentException {
        Node node;
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            node = this.session.getNodeByPath(path, this.session.getRootNode());
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        Document doc = this.newDocument(node);
        if (doc == null) {
            throw new NoSuchDocumentException("No such document: " + path);
        }
        return doc;
    }

    protected void orderBefore(Node node, Node src, Node dest) throws DocumentException {
        try {
            this.session.orderBefore(node, src, dest);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document move(Document source, Document parent, String name) throws DocumentException {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        try {
            if (name == null) {
                name = source.getName();
            }
            Node result = this.session.move(((SQLDocument)source).getNode(), ((SQLDocument)parent).getNode(), name);
            return this.newDocument(result);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected String findFreeName(Node parentNode, String name) throws StorageException {
        if (this.session.hasChildNode(parentNode, name, false)) {
            Matcher m = dotDigitsPattern.matcher(name);
            if (m.matches()) {
                name = m.group(1);
            }
            name = name + "." + System.currentTimeMillis();
        }
        return name;
    }

    public Document copy(Document source, Document parent, String name) throws DocumentException {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        try {
            if (name == null) {
                name = source.getName();
            }
            Node parentNode = ((SQLDocument)parent).getNode();
            name = this.findFreeName(parentNode, name);
            Node copy = this.session.copy(((SQLDocument)source).getNode(), parentNode, name);
            return this.newDocument(copy);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document getVersion(String versionableId, VersionModel versionModel) throws DocumentException {
        try {
            Serializable vid = this.session.getModel().unHackStringId(versionableId);
            Node versionNode = this.session.getVersionByLabel(vid, versionModel.getLabel());
            if (versionNode == null) {
                return null;
            }
            versionModel.setDescription(versionNode.getSimpleProperty("ecm:versionDescription").getString());
            versionModel.setCreated((Calendar)versionNode.getSimpleProperty("ecm:versionCreated").getValue());
            return this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document createProxy(Document doc, Document folder) throws DocumentException {
        try {
            Serializable versionableId;
            Node folderNode = ((SQLDocument)folder).getNode();
            Node targetNode = ((SQLDocument)doc).getNode();
            Serializable targetId = targetNode.getId();
            if (doc.isVersion()) {
                versionableId = (Serializable)doc.getProperty("ecm:versionableId").getValue();
            } else if (doc.isProxy()) {
                targetId = (Serializable)doc.getProperty("ecm:proxyTargetId").getValue();
                versionableId = (Serializable)doc.getProperty("ecm:proxyVersionableId").getValue();
            } else {
                versionableId = targetId;
            }
            String name = this.findFreeName(folderNode, doc.getName());
            Node proxy = this.session.addProxy(targetId, versionableId, folderNode, name, null);
            return this.newDocument(proxy);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document createProxyForVersion(Document parent, Document document, String label) throws DocumentException {
        try {
            Serializable versionableId = ((SQLDocument)document).getNode().getId();
            Node versionNode = this.session.getVersionByLabel(versionableId, label);
            if (versionNode == null) {
                throw new DocumentException("Unknown version: " + label);
            }
            Node parentNode = ((SQLDocument)parent).getNode();
            String name = this.findFreeName(parentNode, document.getName());
            Node proxy = this.session.addProxy(versionNode.getId(), versionableId, parentNode, name, null);
            return this.newDocument(proxy);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Collection<Document> getProxies(Document document, Document parent) throws DocumentException {
        List<Node> proxyNodes;
        try {
            proxyNodes = this.session.getProxies(((SQLDocument)document).getNode(), parent == null ? null : ((SQLDocument)parent).getNode());
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> proxies = new ArrayList<Document>(proxyNodes.size());
        for (Node proxyNode : proxyNodes) {
            proxies.add(this.newDocument(proxyNode));
        }
        return proxies;
    }

    public InputStream getDataStream(String key) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Document importDocument(String uuid, Document parent, String name, String typeName, Map<String, Serializable> properties) throws DocumentException {
        Node parentNode;
        boolean isProxy = typeName.equals("ecm:proxy");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        Long pos = null;
        if (!isProxy) {
            props.put("ecm:lifeCyclePolicy", properties.get("ecm:lifeCyclePolicy"));
            props.put("ecm:lifeCycleState", properties.get("ecm:lifeCycleState"));
            props.put("ecm:lock", properties.get("ecm:lock"));
            props.put("ecm:majorVersion", properties.get("ecm:majorVersion"));
            props.put("ecm:minorVersion", properties.get("ecm:minorVersion"));
            props.put("ecm:isVersion", properties.get("ecm:isVersion"));
        }
        if (parent == null) {
            parentNode = null;
            props.put("ecm:versionableId", properties.get("ecm:versionableId"));
            props.put("ecm:versionCreated", properties.get("ecm:versionCreated"));
            props.put("ecm:versionLabel", properties.get("ecm:versionLabel"));
            props.put("ecm:versionDescription", properties.get("ecm:versionDescription"));
            props.put("ecm:isLatestVersion", properties.get("ecm:isLatestVersion"));
            props.put("ecm:isLatestMajorVersion", properties.get("ecm:isLatestMajorVersion"));
        } else {
            parentNode = ((SQLDocument)parent).getNode();
            if (isProxy) {
                props.put("ecm:proxyTargetId", properties.get("ecm:proxyTargetId"));
                props.put("ecm:proxyVersionableId", properties.get("ecm:proxyVersionableId"));
            } else {
                props.put("ecm:baseVersion", properties.get("ecm:baseVersionId"));
                props.put("ecm:isCheckedIn", properties.get("ecm:isCheckedIn"));
            }
        }
        return this.importChild(uuid, parentNode, name, pos, typeName, props);
    }

    public Query createQuery(String query, Query.Type qType, String ... params) throws QueryException {
        if (qType != Query.Type.NXQL) {
            throw new UnsupportedQueryTypeException(qType);
        }
        if (params != null && params.length != 0) {
            throw new QueryException("Parameters not supported");
        }
        try {
            return new SQLSessionQuery(query);
        }
        catch (QueryParseException e) {
            throw new QueryException(e.getMessage() + ": " + query, (Throwable)e);
        }
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws QueryException {
        return new SQLSessionQuery(query, queryType).executeAndFetch(queryFilter, params);
    }

    private Document newDocument(Node node) throws DocumentException {
        return this.newDocument(node, true);
    }

    private Document newDocument(Node node, boolean readonly) throws DocumentException {
        DocumentType type;
        if (node == null) {
            return null;
        }
        Node targetNode = null;
        String typeName = node.getPrimaryType();
        if (node.isProxy()) {
            try {
                Serializable targetId = node.getSimpleProperty("ecm:proxyTargetId").getValue();
                if (targetId == null) {
                    throw new DocumentException("Proxy has null target");
                }
                targetNode = this.session.getNodeById(targetId);
                typeName = targetNode.getPrimaryType();
            }
            catch (StorageException e) {
                throw new DocumentException((Throwable)((Object)e));
            }
        }
        if ((type = this.getTypeManager().getDocumentType(typeName)) == null) {
            throw new DocumentException("Unknown document type: " + typeName);
        }
        if (node.isProxy()) {
            SQLDocumentLive proxy = new SQLDocumentLive(node, (ComplexType)type, this, false);
            Document target = this.newDocument(targetNode, readonly);
            return new SQLDocumentProxy(proxy, target);
        }
        if (node.isVersion()) {
            return new SQLDocumentVersion(node, (ComplexType)type, this, readonly);
        }
        return new SQLDocumentLive(node, (ComplexType)type, this, false);
    }

    protected Document getDocumentById(Serializable id) throws DocumentException {
        try {
            Node node = this.session.getNodeById(id);
            return node == null ? null : this.newDocument(node);
        }
        catch (StorageException e) {
            throw new DocumentException("Failed to get document: " + id, (Throwable)((Object)e));
        }
    }

    protected List<Document> getDocumentsById(List<Serializable> ids) throws DocumentException {
        ArrayList<Document> docs = new ArrayList<Document>(ids.size());
        try {
            List<Node> nodes = this.session.getNodesByIds(ids);
            for (Node node : nodes) {
                if (node == null) continue;
                docs.add(this.newDocument(node));
            }
        }
        catch (StorageException e) {
            throw new DocumentException(e.toString(), (Throwable)((Object)e));
        }
        return docs;
    }

    protected Binary getBinary(InputStream in) throws DocumentException {
        try {
            return this.session.getBinary(in);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document resolvePath(Node node, String path) throws DocumentException {
        try {
            return this.newDocument(this.session.getNodeByPath(path, node));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document getParent(Node node) throws DocumentException {
        try {
            return this.newDocument(this.session.getParentNode(node));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected String getPath(Node node) throws DocumentException {
        try {
            return this.session.getPath(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document getChild(Node node, String name) throws DocumentException {
        Node childNode;
        try {
            childNode = this.session.getChildNode(node, name, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        Document doc = this.newDocument(childNode);
        if (doc == null) {
            throw new NoSuchDocumentException("No such document: " + name);
        }
        return doc;
    }

    protected List<Document> getChildren(Node node) throws DocumentException {
        List<Node> nodes;
        try {
            nodes = this.session.getChildren(node, null, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> children = new ArrayList<Document>(nodes.size());
        for (Node n : nodes) {
            children.add(this.newDocument(n));
        }
        return children;
    }

    protected boolean hasChild(Node node, String name) throws DocumentException {
        try {
            return this.session.hasChildNode(node, name, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected boolean hasChildren(Node node) throws DocumentException {
        try {
            return this.session.hasChildren(node, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document addChild(Node parent, String name, Long pos, String typeName) throws DocumentException {
        try {
            return this.newDocument(this.session.addChildNode(parent, name, pos, typeName, false));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document importChild(String uuid, Node parent, String name, Long pos, String typeName, Map<String, Serializable> props) throws DocumentException {
        try {
            Serializable id = this.session.getModel().unHackStringId(uuid);
            Node node = this.session.addChildNode(id, parent, name, pos, typeName, false);
            for (Map.Entry<String, Serializable> entry : props.entrySet()) {
                node.setSingleProperty(entry.getKey(), entry.getValue());
            }
            return this.newDocument(node, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected List<Node> getComplexList(Node node, String name) throws DocumentException {
        List<Node> nodes;
        try {
            nodes = this.session.getChildren(node, name, true);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        return nodes;
    }

    protected void remove(Node node) throws DocumentException {
        try {
            this.session.removeNode(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document checkIn(Node node, String label, String checkinComment) throws DocumentException {
        try {
            Node versionNode = this.session.checkIn(node, label, checkinComment);
            return versionNode == null ? null : this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected void checkOut(Node node) throws DocumentException {
        try {
            this.session.checkOut(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected void restore(Node node, Node version) throws DocumentException {
        try {
            this.session.restore(node, version);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document getVersionByLabel(Serializable versionSeriesId, String label) throws DocumentException {
        try {
            Node versionNode = this.session.getVersionByLabel(versionSeriesId, label);
            return versionNode == null ? null : this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected List<Document> getVersions(Serializable versionSeriesId) throws DocumentException {
        List<Node> versionNodes;
        try {
            versionNodes = this.session.getVersions(versionSeriesId);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> versions = new ArrayList<Document>(versionNodes.size());
        for (Node versionNode : versionNodes) {
            versions.add(this.newDocument(versionNode));
        }
        return versions;
    }

    public Document getLastVersion(Serializable versionSeriesId) throws DocumentException {
        try {
            Node versionNode = this.session.getLastVersion(versionSeriesId);
            if (versionNode == null) {
                return null;
            }
            return this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Node getNodeById(Serializable id) throws DocumentException {
        try {
            return this.session.getNodeById(id);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Property makeACLProperty(Node node) throws DocumentException {
        CollectionProperty property;
        try {
            property = node.getCollectionProperty("ecm:acl");
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        return new SQLCollectionProperty(this, property, null, false);
    }

    protected Property makeProperty(Node node, String name, ComplexType parentType, boolean readonly) throws DocumentException {
        return this.makeProperties(node, name, (Type)parentType, readonly, 0).get(0);
    }

    protected List<Property> makeProperties(Node node, String name, Type parentType, boolean readonly, int complexListSize) throws DocumentException {
        List<Object> childNodes;
        Model model;
        boolean complexList = parentType instanceof ListType;
        try {
            model = this.session.getModel();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        Type type = model.getSpecialPropertyType(name);
        if (type == null) {
            Field field;
            if (complexList) {
                field = ((ListType)parentType).getField();
            } else {
                field = ((ComplexType)parentType).getField(name);
                if (field == null) {
                    throw new NoSuchPropertyException(name);
                }
                name = field.getName().getPrefixedName();
            }
            type = field.getType();
        }
        if (type.isSimpleType()) {
            SimpleProperty prop;
            try {
                prop = node.getSimpleProperty(name);
            }
            catch (StorageException e) {
                throw new DocumentException((Throwable)((Object)e));
            }
            SQLSimpleProperty property = new SQLSimpleProperty(prop, type, readonly);
            return Collections.singletonList(property);
        }
        if (type.isListType()) {
            SQLBaseProperty property;
            ListType listType = (ListType)type;
            if (listType.getFieldType().isSimpleType()) {
                CollectionProperty prop;
                try {
                    prop = node.getCollectionProperty(name);
                }
                catch (StorageException e) {
                    throw new DocumentException((Throwable)((Object)e));
                }
                property = new SQLCollectionProperty(this, prop, listType, readonly);
            } else {
                property = new SQLComplexListProperty(node, listType, name, this, readonly);
            }
            return Collections.singletonList(property);
        }
        try {
            if (complexList) {
                if (complexListSize == -1) {
                    childNodes = this.session.getChildren(node, name, true);
                } else {
                    childNodes = new ArrayList(complexListSize);
                    for (int i = 0; i < complexListSize; ++i) {
                        Node childNode = this.session.addChildNode(node, name, Long.valueOf(i), type.getName(), true);
                        childNodes.add(childNode);
                    }
                }
            } else {
                Node childNode = this.session.getChildNode(node, name, true);
                if (childNode == null) {
                    childNode = this.session.addChildNode(node, name, null, type.getName(), true);
                }
                childNodes = Collections.singletonList(childNode);
            }
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ComplexType complexType = (ComplexType)type;
        ArrayList<Property> properties = new ArrayList<Property>(childNodes.size());
        for (Node node2 : childNodes) {
            SQLComplexProperty property = TypeConstants.isContentType((Type)type) ? new SQLContentProperty(node2, complexType, this, readonly) : new SQLComplexProperty(node2, complexType, this, readonly);
            properties.add(property);
        }
        return properties;
    }

    public void requireReadAclsUpdate() {
        this.session.requireReadAclsUpdate();
    }

    protected class SQLSessionQuery
    implements FilterableQuery {
        protected final String query;
        protected final String queryType;

        public SQLSessionQuery(String query) {
            this.query = query;
            this.queryType = "NXQL";
        }

        public SQLSessionQuery(String query, String queryType) {
            this.query = query;
            this.queryType = queryType;
        }

        public QueryResult execute() throws QueryException {
            return this.execute(QueryFilter.EMPTY, false);
        }

        public QueryResult execute(boolean countTotal) throws QueryException {
            return this.execute(QueryFilter.EMPTY, countTotal);
        }

        public QueryResult execute(QueryFilter queryFilter, boolean countTotal) throws QueryException {
            try {
                String query = this.query;
                Matcher matcher = ORDER_BY_PATH_ASC.matcher(query);
                Boolean orderByPath = matcher.matches() ? Boolean.TRUE : ((matcher = ORDER_BY_PATH_DESC.matcher(query)).matches() ? Boolean.FALSE : null);
                long limit = 0L;
                long offset = 0L;
                if (orderByPath != null) {
                    query = matcher.group(1);
                    limit = queryFilter.getLimit();
                    offset = queryFilter.getOffset();
                    queryFilter = QueryFilter.withoutLimitOffset((QueryFilter)queryFilter);
                }
                PartialList<Serializable> list = SQLSession.this.session.query(query, queryFilter, countTotal);
                return new SQLQueryResult(SQLSession.this, list, orderByPath, limit, offset);
            }
            catch (StorageException e) {
                throw new QueryException(e.getMessage(), (Throwable)((Object)e));
            }
        }

        public IterableQueryResult executeAndFetch(QueryFilter queryFilter, Object ... params) throws QueryException {
            try {
                return SQLSession.this.session.queryAndFetch(this.query, this.queryType, queryFilter, params);
            }
            catch (StorageException e) {
                throw new QueryException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }
}

