/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;

public class ResultSetQueryResult
implements IterableQueryResult,
Iterator<Map<String, Serializable>> {
    private QueryMaker.Query q;
    private PreparedStatement ps;
    private ResultSet rs;
    private Map<String, Serializable> next;
    private boolean eof;
    private long pos;
    private long size = -1L;
    private final JDBCMapperLogger logger;

    public ResultSetQueryResult(QueryMaker queryMaker, String query, QueryFilter queryFilter, Session.PathResolver pathResolver, JDBCMapper mapper, Object ... params) throws StorageException, SQLException {
        this.logger = mapper.logger;
        this.q = queryMaker.buildQuery(mapper.sqlInfo, mapper.model, pathResolver, query, queryFilter, params);
        if (this.q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            this.ps = null;
            this.rs = null;
            this.eof = true;
            return;
        }
        this.eof = false;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(this.q.selectInfo.sql, this.q.selectParams);
        }
        this.ps = mapper.connection.prepareStatement(this.q.selectInfo.sql, 1004, 1007);
        int i = 1;
        for (Serializable object : this.q.selectParams) {
            if (object instanceof Calendar) {
                Calendar cal = (Calendar)object;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                this.ps.setTimestamp(i++, ts, cal);
                continue;
            }
            if (object instanceof String[]) {
                Array array = mapper.sqlInfo.dialect.createArrayOf(12, (Object[])object, mapper.connection);
                this.ps.setArray(i++, array);
                continue;
            }
            this.ps.setObject(i++, object);
        }
        this.rs = this.ps.executeQuery();
    }

    protected static void closePreparedStatement(PreparedStatement ps) throws SQLException {
        try {
            ps.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
                ResultSetQueryResult.closePreparedStatement(this.ps);
            }
            catch (SQLException e) {
                this.logger.error("Error closing statement: " + e.getMessage(), e);
            }
            finally {
                this.pos = -1L;
                this.rs = null;
                this.ps = null;
                this.q = null;
            }
        }
    }

    protected void finalize() {
        if (this.rs != null) {
            this.logger.warn("Closing an IterableQueryResult for you. Please close them yourself.");
        }
        this.close();
    }

    public long size() {
        if (this.size != -1L) {
            return this.size;
        }
        try {
            int old = this.rs.isBeforeFirst() ? -1 : (this.rs.isAfterLast() ? -2 : this.rs.getRow());
            this.rs.last();
            this.size = this.rs.getRow();
            if (old == -1) {
                this.rs.beforeFirst();
            } else if (old == -2) {
                this.rs.afterLast();
            } else if (old != 0) {
                this.rs.absolute(old);
            }
            return this.size;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long pos() {
        return this.pos;
    }

    public void skipTo(long pos) {
        if (this.rs == null || pos < 0L) {
            this.pos = -1L;
            return;
        }
        try {
            boolean available = this.rs.absolute((int)pos + 1);
            if (available) {
                this.next = this.fetchCurrent();
                this.eof = false;
                this.pos = pos;
            } else {
                this.next = null;
                this.eof = true;
                this.pos = -1L;
            }
        }
        catch (SQLException e) {
            this.logger.error("Error skipping to: " + pos + ": " + e.getMessage(), e);
        }
    }

    public Iterator<Map<String, Serializable>> iterator() {
        return this;
    }

    protected Map<String, Serializable> fetchNext() throws StorageException, SQLException {
        if (this.rs == null) {
            return null;
        }
        if (!this.rs.next()) {
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> END");
            }
            return null;
        }
        return this.fetchCurrent();
    }

    protected Map<String, Serializable> fetchCurrent() throws SQLException {
        Map<String, Serializable> map = this.q.selectInfo.mapMaker.makeMap(this.rs);
        if (this.logger.isLogEnabled()) {
            this.logger.logMap(map);
        }
        return map;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.eof) {
            return false;
        }
        try {
            this.next = this.fetchNext();
        }
        catch (Exception e) {
            this.logger.error("Error fetching next: " + e.getMessage(), e);
        }
        this.eof = this.next == null;
        return !this.eof;
    }

    @Override
    public Map<String, Serializable> next() {
        if (!this.hasNext()) {
            this.pos = -1L;
            throw new NoSuchElementException();
        }
        Map<String, Serializable> n = this.next;
        this.next = null;
        ++this.pos;
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

