/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectSQLServer
extends Dialect {
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_FULLTEXT_CATALOG = "nuxeo";
    protected final String fulltextAnalyzer;
    protected final String fulltextCatalog;

    public DialectSQLServer(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        this.fulltextAnalyzer = repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer;
        this.fulltextCatalog = repositoryDescriptor.fulltextCatalog == null ? DEFAULT_FULLTEXT_CATALOG : repositoryDescriptor.fulltextCatalog;
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getNullColumnString() {
        return " NULL";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("NVARCHAR(4000)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("DATETIME", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(256)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INT", 4);
            }
            case FTINDEXED: {
                throw new AssertionError((Object)type);
            }
            case FTSTORED: {
                return this.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("SMALLINT", 5);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR(8000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return this.getBinaryManager().getBinary(string);
                }
                return string;
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("CREATE FULLTEXT INDEX ON %s (", table.getQuotedName()));
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            buf.append(String.format("%s LANGUAGE %s", it.next().getQuotedName(), this.getQuotedFulltextAnalyzer()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        String fulltextUniqueIndex = "[fulltext_pk]";
        buf.append(String.format(") KEY INDEX %s ON [%s]", fulltextUniqueIndex, this.fulltextCatalog));
        return buf.toString();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        Dialect.FulltextQuery ft = DialectSQLServer.analyzeFulltextQuery(query = query.replace("*", "%"));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return DialectSQLServer.translateFulltext(ft, "OR", "AND", "AND NOT", "\"");
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String tableAlias = "_nxfttbl" + nthSuffix;
        String scoreAlias = "_nxscore" + nthSuffix;
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>();
        if (nthMatch == 1) {
            info.joins.add(new Join(2, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.joins.add(new Join(2, String.format("CONTAINSTABLE(%s, *, ?, LANGUAGE %s)", ft.getQuotedName(), this.getQuotedFulltextAnalyzer()), tableAlias, fulltextQuery, ftMain.getFullQuotedName(), String.format("%s.[KEY]", tableAlias)));
        info.whereExpr = String.format("%s.[KEY] IS NOT NULL", tableAlias);
        info.scoreExpr = String.format("%s.RANK / 1000.0 AS %s", tableAlias, scoreAlias);
        info.scoreAlias = scoreAlias;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    protected String getQuotedFulltextAnalyzer() {
        if (!Character.isDigit(this.fulltextAnalyzer.charAt(0))) {
            return String.format("'%s'", this.fulltextAnalyzer);
        }
        return this.fulltextAnalyzer;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("dbo.NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("dbo.NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"NVARCHAR(36)"));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextCatalog", (Serializable)((Object)this.fulltextCatalog));
        return properties;
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "EXEC dbo.NX_CLUSTER_INVAL ?, ?, ?";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "DELETE I OUTPUT DELETED.[id], DELETED.[fragments], DELETED.[kind] FROM [cluster_invals] AS I WHERE I.[nodeid] = @@SPID";
    }
}

