/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFileableObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoDocument
extends NuxeoFileableObject
implements Document {
    public NuxeoDocument(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        super(session, data, type);
    }

    public void cancelCheckOut() {
        this.service.cancelCheckOut(this.getId());
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        String verId = this.service.checkIn(this.getId(), major, properties, this.type, contentStream, checkinComment);
        return this.session.createObjectId(verId);
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.checkIn(major, properties, contentStream, checkinComment);
    }

    public ObjectId checkOut() {
        String pwcId = this.service.checkOut(this.getId());
        return this.session.createObjectId(pwcId);
    }

    public NuxeoDocument copy(ObjectId target) {
        return this.copy(target, (Map)null, (VersioningState)null, (List)null, (List)null, (List)null, this.session.getDefaultContext());
    }

    public NuxeoDocument copy(ObjectId target, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (target == null || target.getId() == null) {
            throw new CmisInvalidArgumentException("Invalid target: " + target);
        }
        if (context == null) {
            context = this.session.getDefaultContext();
        }
        NuxeoObjectData newData = this.service.copy(this.getId(), target.getId(), properties, (TypeDefinition)this.type, versioningState, policies, addACEs, removeACEs, context);
        return (NuxeoDocument)this.session.getObjectFactory().convertObject(newData, context);
    }

    public void deleteAllVersions() {
        throw new UnsupportedOperationException();
    }

    public ObjectId deleteContentStream() {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.deleteContentStream(this.getRepositoryId(), (Holder<String>)objectIdHolder, (Holder<String>)changeTokenHolder, null);
        String objectId = (String)objectIdHolder.getValue();
        return objectId == null ? null : this.session.createObjectId(objectId);
    }

    public List<Document> getAllVersions() {
        throw new UnsupportedOperationException();
    }

    public List<Document> getAllVersions(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getCheckinComment() {
        throw new UnsupportedOperationException();
    }

    public ContentStream getContentStream() {
        return this.getContentStream(null);
    }

    public ContentStream getContentStream(String streamId) {
        try {
            return this.service.getContentStream(this.getRepositoryId(), this.getId(), streamId, null, null, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
    }

    public String getContentStreamFileName() {
        throw new UnsupportedOperationException();
    }

    public String getContentStreamId() {
        throw new UnsupportedOperationException();
    }

    public long getContentStreamLength() {
        throw new UnsupportedOperationException();
    }

    public String getContentStreamMimeType() {
        throw new UnsupportedOperationException();
    }

    public Document getObjectOfLatestVersion(boolean major) {
        throw new UnsupportedOperationException();
    }

    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getVersionLabel() {
        throw new UnsupportedOperationException();
    }

    public String getVersionSeriesCheckedOutBy() {
        throw new UnsupportedOperationException();
    }

    public String getVersionSeriesCheckedOutId() {
        throw new UnsupportedOperationException();
    }

    public String getVersionSeriesId() {
        throw new UnsupportedOperationException();
    }

    public Boolean isImmutable() {
        throw new UnsupportedOperationException();
    }

    public Boolean isLatestMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public Boolean isLatestVersion() {
        throw new UnsupportedOperationException();
    }

    public Boolean isMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public Boolean isVersionSeriesCheckedOut() {
        throw new UnsupportedOperationException();
    }

    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.setContentStream(this.getRepositoryId(), (Holder<String>)objectIdHolder, overwrite, (Holder<String>)changeTokenHolder, contentStream, null);
        String objectId = (String)objectIdHolder.getValue();
        return objectId == null ? null : this.session.createObjectId(objectId);
    }

    public ItemIterable<Relationship> getRelationships(boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, ObjectType type, OperationContext context) {
        throw new UnsupportedOperationException();
    }
}

