/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoDocument;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFileableObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoFolder
extends NuxeoFileableObject
implements Folder {
    public NuxeoFolder(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        super(session, data, type);
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, contentStream, versioningState, null, null, null, this.session.getDefaultContext());
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ArrayList<String> policyIds;
        Properties props;
        if (properties == null) {
            props = null;
        } else {
            String typeId = (String)properties.get("cmis:objectTypeId");
            if (typeId == null) {
                throw new IllegalArgumentException("Missing type");
            }
            ObjectType type = this.session.getTypeDefinition(typeId);
            if (type == null) {
                throw new IllegalArgumentException("Unknown type: " + typeId);
            }
            props = this.convertProperties(properties, type);
        }
        if (policies == null) {
            policyIds = null;
        } else {
            policyIds = new ArrayList<String>(policies.size());
            for (Policy p : policies) {
                policyIds.add(p.getId());
            }
        }
        AccessControlListImpl addAcl = addAces == null ? null : new AccessControlListImpl(addAces);
        AccessControlListImpl removeAcl = removeAces == null ? null : new AccessControlListImpl(removeAces);
        String id = this.service.createDocument(this.getRepositoryId(), props, this.getId(), contentStream, versioningState, policyIds, (Acl)addAcl, (Acl)removeAcl, null);
        return (Document)this.session.getObject((ObjectId)new ObjectIdImpl(id), context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties convertProperties(Map<String, ?> properties, ObjectType type) {
        Map propDefs = type.getPropertyDefinitions();
        PropertiesImpl props = new PropertiesImpl();
        for (Map.Entry<String, ?> es : properties.entrySet()) {
            PropertyString prop;
            Object firstValue;
            List<?> values;
            boolean single;
            String key = es.getKey();
            Object value = es.getValue();
            PropertyDefinition pd = (PropertyDefinition)propDefs.get(key);
            if (pd == null) {
                throw new IllegalArgumentException("Unknown property '" + key + "' for type: " + type.getId());
            }
            boolean bl = single = pd.getCardinality() == Cardinality.SINGLE;
            if (value == null) {
                values = null;
            } else if (value instanceof List) {
                if (single) {
                    throw new IllegalArgumentException("Property '" + key + "' is not a multi value property!");
                }
                values = (List)value;
            } else {
                if (!single) {
                    throw new IllegalArgumentException("Property '" + key + "' is not a single value property!");
                }
                values = Collections.singletonList(value);
            }
            Object v1 = firstValue = values == null ? null : values.get(0);
            if (pd instanceof PropertyStringDefinition) {
                prop = objectFactory.createPropertyStringData(key, values);
            } else if (pd instanceof PropertyIdDefinition) {
                prop = objectFactory.createPropertyIdData(key, values);
            } else if (pd instanceof PropertyHtmlDefinition) {
                prop = objectFactory.createPropertyHtmlData(key, values);
            } else if (pd instanceof PropertyUriDefinition) {
                prop = objectFactory.createPropertyUriData(key, values);
            } else if (pd instanceof PropertyIntegerDefinition) {
                if (firstValue == null) {
                    prop = objectFactory.createPropertyIntegerData(key, (List)null);
                } else if (firstValue instanceof BigInteger) {
                    prop = objectFactory.createPropertyIntegerData(key, values);
                } else {
                    if (!(firstValue instanceof Byte) && !(firstValue instanceof Short) && !(firstValue instanceof Integer) && !(firstValue instanceof Long)) throw new IllegalArgumentException("Property '" + key + "' is an Integer property");
                    ArrayList<BigInteger> list = new ArrayList<BigInteger>(values.size());
                    for (Object v : values) {
                        list.add(BigInteger.valueOf(((Number)v).longValue()));
                    }
                    prop = objectFactory.createPropertyIntegerData(key, list);
                }
            } else if (pd instanceof PropertyBooleanDefinition) {
                prop = objectFactory.createPropertyBooleanData(key, values);
            } else if (pd instanceof PropertyDecimalDefinition) {
                prop = objectFactory.createPropertyDecimalData(key, values);
            } else {
                if (!(pd instanceof PropertyDateTimeDefinition)) throw new CmisRuntimeException("Unknown class: " + pd.getClass().getName());
                prop = objectFactory.createPropertyDateTimeData(key, values);
            }
            props.addProperty((PropertyData)prop);
        }
        return props;
    }

    public NuxeoDocument createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState) {
        return this.createDocumentFromSource(source, (Map)properties, versioningState, (List)null, (List)null, (List)null, this.session.getDefaultContext());
    }

    public NuxeoDocument createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (source == null || source.getId() == null) {
            throw new CmisInvalidArgumentException("Invalid source: " + source);
        }
        if (context == null) {
            context = this.session.getDefaultContext();
        }
        NuxeoObjectData newData = this.service.copy(source.getId(), this.getId(), properties, (TypeDefinition)this.type, versioningState, policies, addACEs, removeACEs, context);
        return (NuxeoDocument)this.session.getObjectFactory().convertObject(newData, context);
    }

    public Folder createFolder(Map<String, ?> properties) {
        return this.createFolder(properties, null, null, null, this.session.getDefaultContext());
    }

    public Folder createFolder(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Policy createPolicy(Map<String, ?> properties) {
        return this.createPolicy(properties, null, null, null, this.session.getDefaultContext());
    }

    public Policy createPolicy(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public List<String> deleteTree(boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
        FailedToDeleteData failed = this.service.deleteTree(this.getRepositoryId(), this.getId(), allVersions, unfile, continueOnFailure, null);
        if (failed == null || failed.getIds() == null || failed.getIds().isEmpty()) {
            return null;
        }
        return failed.getIds();
    }

    public List<ObjectType> getAllowedChildObjectTypes() {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<CmisObject> getChildren() {
        return this.getChildren(this.session.getDefaultContext());
    }

    public ItemIterable<CmisObject> getChildren(OperationContext context) {
        NuxeoObjectFactory objectFactory = this.session.getObjectFactory();
        OperationContextImpl ctx = new OperationContextImpl(context);
        AbstractPageFetcher<CmisObject> pageFetcher = new AbstractPageFetcher<CmisObject>((long)ctx.getMaxItemsPerPage(), (OperationContext)ctx, (ObjectFactory)objectFactory){
            final /* synthetic */ OperationContext val$ctx;
            final /* synthetic */ ObjectFactory val$objectFactory;
            {
                this.val$ctx = operationContext;
                this.val$objectFactory = objectFactory;
                super(x0);
            }

            protected AbstractPageFetcher.Page<CmisObject> fetchPage(long skipCount) {
                DocumentModelList children;
                ArrayList<CmisObject> items = new ArrayList<CmisObject>();
                try {
                    children = NuxeoFolder.this.service.getCoreSession().getChildren(NuxeoFolder.this.data.doc.getRef());
                }
                catch (ClientException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                }
                long totalItems = 0L;
                long skip = skipCount;
                for (DocumentModel child : children) {
                    if (NuxeoFolder.this.service.isFilteredOut(child)) continue;
                    ++totalItems;
                    if (skip > 0L) {
                        --skip;
                        continue;
                    }
                    if ((long)items.size() > this.maxNumItems) continue;
                    NuxeoObjectData data = new NuxeoObjectData(NuxeoFolder.this.service, child, this.val$ctx);
                    CmisObject ob = this.val$objectFactory.convertObject((ObjectData)data, this.val$ctx);
                    items.add(ob);
                }
                return new AbstractPageFetcher.Page(items, totalItems, totalItems > skipCount + (long)items.size());
            }
        };
        return new CollectionIterable((AbstractPageFetcher)pageFetcher);
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth) {
        throw new UnsupportedOperationException();
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Folder getFolderParent() {
        if (this.isRootFolder()) {
            return null;
        }
        List<Folder> parents = this.getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return parents.get(0);
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth) {
        throw new UnsupportedOperationException();
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        return this.data.doc.getPathAsString();
    }

    public boolean isRootFolder() {
        return this.data.doc.getPath().isRoot();
    }

    public ItemIterable<Relationship> getRelationships(boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, ObjectType type, OperationContext context) {
        throw new UnsupportedOperationException();
    }
}

