/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.RenditionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoDocument;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFolder;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoProperty;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;

public abstract class NuxeoObject
implements CmisObject {
    protected static final Set<Updatability> UPDATABILITY_READWRITE = Collections.singleton(Updatability.READWRITE);
    protected final NuxeoSession session;
    protected final NuxeoCmisService service;
    public final NuxeoObjectData data;
    protected final ObjectType type;
    protected static final BindingsObjectFactory objectFactory = new BindingsObjectFactoryImpl();

    public static NuxeoObject construct(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        BaseTypeId baseTypeId = type.getBaseTypeId();
        switch (baseTypeId) {
            case CMIS_FOLDER: {
                return new NuxeoFolder(session, data, type);
            }
            case CMIS_DOCUMENT: {
                return new NuxeoDocument(session, data, type);
            }
            case CMIS_POLICY: {
                throw new UnsupportedOperationException(baseTypeId.toString());
            }
            case CMIS_RELATIONSHIP: {
                throw new UnsupportedOperationException(baseTypeId.toString());
            }
        }
        throw new RuntimeException(baseTypeId.toString());
    }

    public NuxeoObject(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        this.session = session;
        this.service = session.getService();
        this.data = data;
        this.type = type;
    }

    public String getRepositoryId() {
        return this.session.getRepositoryId();
    }

    public String getId() {
        return this.data.getId();
    }

    public ObjectType getType() {
        return this.type;
    }

    public BaseTypeId getBaseTypeId() {
        return this.data.getBaseTypeId();
    }

    public ObjectType getBaseType() {
        return this.session.getTypeDefinition(this.getBaseTypeId().value());
    }

    public String getName() {
        return NuxeoPropertyData.NuxeoPropertyDataName.getValue(this.data.doc);
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public void setName(String name) {
        this.setProperty("cmis:name", name);
    }

    public void delete(boolean allVersions) {
        this.service.deleteObject(this.getRepositoryId(), this.getId(), allVersions, null);
    }

    public ObjectId updateProperties() {
        CoreSession coreSession = this.session.getCoreSession();
        try {
            this.data.doc = coreSession.saveDocument(this.data.doc);
            coreSession.save();
            return this.session.createObjectId(this.data.doc.getId());
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ObjectId updateProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> en : properties.entrySet()) {
            this.data.getProperty(en.getKey()).setValue(en.getValue());
        }
        return this.updateProperties();
    }

    public <T> T getPropertyValue(String id) {
        return (T)this.data.getProperty(id).getValue();
    }

    public <T> Property<T> getProperty(String id) {
        return new NuxeoProperty(this, this.type, id);
    }

    public List<Property<?>> getProperties() {
        Collection defs = this.type.getPropertyDefinitions().values();
        ArrayList list = new ArrayList(defs.size());
        for (PropertyDefinition pd : defs) {
            list.add(new NuxeoProperty(this, this.type, pd.getId()));
        }
        return list;
    }

    public void setProperty(String id, Object value) {
        NuxeoPropertyDataBase<?> prop = this.data.getProperty(id);
        prop.setValue(value);
    }

    public void addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public void applyPolicy(ObjectId policyId) {
        throw new CmisNotSupportedException();
    }

    public Acl getAcl() {
        throw new CmisNotSupportedException();
    }

    public Acl getAcl(boolean onlyBasicPermissions) {
        throw new CmisNotSupportedException();
    }

    public void removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public AllowableActions getAllowableActions() {
        return NuxeoObjectData.getAllowableActions(this.data.doc, this.data.creation);
    }

    public List<Policy> getPolicies() {
        return Collections.emptyList();
    }

    public void removePolicy(ObjectId policyId) {
        throw new CmisNotSupportedException();
    }

    public List<Relationship> getRelationships() {
        throw new CmisNotSupportedException();
    }

    public ItemIterable<Relationship> getRelationships(boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, ObjectType type, OperationContext context, int itemsPerPage) {
        throw new CmisNotSupportedException();
    }

    public List<Rendition> getRenditions() {
        List<RenditionData> renditions = NuxeoObjectData.getRenditions(this.data.doc, this.service.getCallContext());
        ArrayList<Rendition> res = new ArrayList<Rendition>(renditions.size());
        for (RenditionData ren : renditions) {
            long length = ren.getBigLength() == null ? -1L : ren.getBigLength().longValue();
            int height = ren.getBigHeight() == null ? -1 : ren.getBigHeight().intValue();
            int width = ren.getBigWidth() == null ? -1 : ren.getBigWidth().intValue();
            RenditionImpl rendition = new RenditionImpl((Session)this.session, this.getId(), ren.getStreamId(), ren.getRenditionDocumentId(), ren.getKind(), length, ren.getMimeType(), ren.getTitle(), height, width);
            res.add((Rendition)rendition);
        }
        return res;
    }

    public boolean isChanged() {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        try {
            this.data.doc.refresh();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void refreshIfOld(long durationInMillis) {
        throw new UnsupportedOperationException();
    }

    public long getRefreshTimestamp() {
        throw new UnsupportedOperationException();
    }
}

