/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.PersistentPropertyImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.DocumentTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.FolderTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.PolicyTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.RelationshipTypeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoObjectFactory
implements ObjectFactory {
    private final NuxeoSession session;

    public NuxeoObjectFactory(NuxeoSession session) {
        this.session = session;
    }

    public NuxeoObject convertObject(ObjectData data, OperationContext context) {
        if (data == null || data.getProperties() == null || data.getProperties().getProperties() == null) {
            return null;
        }
        PropertyData propData = (PropertyData)data.getProperties().getProperties().get("cmis:objectTypeId");
        if (!(propData instanceof PropertyId)) {
            throw new IllegalArgumentException("Property cmis:objectTypeId must be of type PropertyIdData, not: " + propData.getClass().getName());
        }
        ObjectType type = this.session.getTypeDefinition((String)propData.getFirstValue());
        return NuxeoObject.construct(this.session, (NuxeoObjectData)data, type);
    }

    public ObjectType getTypeFromObjectData(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public Ace createAce(String principal, List<String> permissions) {
        throw new UnsupportedOperationException();
    }

    public Acl createAcl(List<Ace> aces) {
        throw new UnsupportedOperationException();
    }

    public <T> Property<T> createProperty(PropertyDefinition<T> type, List<T> values) {
        return new PersistentPropertyImpl(type, values);
    }

    public ContentStream createContentStream(String filename, long length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(filename, BigInteger.valueOf(length), mimetype, stream);
    }

    public Acl convertAces(List<Ace> aces) {
        throw new UnsupportedOperationException();
    }

    public ContentStream convertContentStream(ContentStream contentStream) {
        throw new UnsupportedOperationException();
    }

    public List<String> convertPolicies(List<Policy> policies) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Property<?>> convertProperties(ObjectType objectType, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public Properties convertProperties(Map<String, ?> properties, ObjectType type, Set<Updatability> updatabilityFilter) {
        throw new UnsupportedOperationException();
    }

    public List<PropertyData<?>> convertQueryProperties(Properties properties) {
        throw new UnsupportedOperationException();
    }

    public QueryResult convertQueryResult(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public Rendition convertRendition(String objectId, RenditionData rendition) {
        throw new UnsupportedOperationException();
    }

    public ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof DocumentTypeDefinition) {
            return new DocumentTypeImpl((Session)this.session, (DocumentTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof FolderTypeDefinition) {
            return new FolderTypeImpl((Session)this.session, (FolderTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof RelationshipTypeDefinition) {
            return new RelationshipTypeImpl((Session)this.session, (RelationshipTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof PolicyTypeDefinition) {
            return new PolicyTypeImpl((Session)this.session, (PolicyTypeDefinition)typeDefinition);
        }
        throw new CmisRuntimeException("Unknown base class: " + typeDefinition.getClass().getName());
    }

    public ChangeEvent convertChangeEvent(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public ChangeEvents convertChangeEvents(String changeLogToken, ObjectList objectList) {
        throw new UnsupportedOperationException();
    }
}

