/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

public class NuxeoTypeHelper {
    private static final Log log = LogFactory.getLog(NuxeoTypeHelper.class);
    public static final String NUXEO_DOCUMENT = "Document";
    public static final String NUXEO_FOLDER = "Folder";
    public static final String NUXEO_FILE = "File";
    public static final String NUXEO_ORDERED_FOLDER = "OrderedFolder";
    public static final String NX_DUBLINCORE = "dublincore";
    public static final String NX_DC_TITLE = "dc:title";
    public static final String NX_DC_CREATED = "dc:created";
    public static final String NX_DC_CREATOR = "dc:creator";
    public static final String NX_DC_MODIFIED = "dc:modified";
    public static final String NX_ICON = "common:icon";
    private static final String NAMESPACE = "http://ns.nuxeo.org/cmis/type/";

    public static String getParentTypeId(DocumentType documentType) {
        String nuxeoTypeId = documentType.getName();
        if (NUXEO_DOCUMENT.equals(nuxeoTypeId) || documentType.getFacets().contains("HiddenInNavigation") || !documentType.hasSchema(NX_DUBLINCORE)) {
            return null;
        }
        if (NUXEO_FOLDER.equals(nuxeoTypeId)) {
            return BaseTypeId.CMIS_FOLDER.value();
        }
        DocumentType superType = (DocumentType)documentType.getSuperType();
        if (superType == null) {
            return null;
        }
        String parentId = NuxeoTypeHelper.mappedId(superType.getName());
        if (NUXEO_FOLDER.equals(parentId)) {
            parentId = BaseTypeId.CMIS_FOLDER.value();
        }
        if (NUXEO_DOCUMENT.equals(parentId)) {
            parentId = BaseTypeId.CMIS_DOCUMENT.value();
        }
        return parentId;
    }

    public static TypeDefinition construct(DocumentType documentType, String parentId) {
        String nuxeoTypeId = documentType.getName();
        String id = NuxeoTypeHelper.mappedId(nuxeoTypeId);
        AbstractTypeDefinition type = NuxeoTypeHelper.constructBase(id, parentId, documentType.isFolder(), documentType, nuxeoTypeId, true);
        for (Schema schema : documentType.getSchemas()) {
            NuxeoTypeHelper.addSchemaPropertyDefinitions(type, schema);
        }
        return type;
    }

    public static TypeDefinition constructCmisBase(BaseTypeId base, SchemaManager schemaManager) {
        AbstractTypeDefinition type = NuxeoTypeHelper.constructBase(base.value(), null, base == BaseTypeId.CMIS_FOLDER, null, null, true);
        DocumentType dt = schemaManager.getDocumentType(NUXEO_FOLDER);
        NuxeoTypeHelper.addSchemaPropertyDefinitions(type, dt.getSchema(NX_DUBLINCORE));
        return type;
    }

    protected static void addSchemaPropertyDefinitions(AbstractTypeDefinition type, Schema schema) {
        for (Field field : schema.getFields()) {
            PropertyType propertyType;
            Cardinality cardinality;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                log.debug((Object)("Ignoring complex type: " + schema.getName() + '/' + field.getName() + " in type: " + type.getId()));
                continue;
            }
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (!listFieldType.isSimpleType()) {
                    log.debug((Object)("Ignoring complex list: " + schema.getName() + '/' + field.getName() + " in type: " + type.getId()));
                    continue;
                }
                cardinality = Cardinality.MULTI;
                propertyType = NuxeoTypeHelper.getPropertType((SimpleType)listFieldType);
            } else {
                cardinality = Cardinality.SINGLE;
                propertyType = NuxeoTypeHelper.getPropertType((SimpleType)fieldType);
            }
            String name = field.getName().getPrefixedName();
            PropertyDefinition<?> pd = NuxeoTypeHelper.newPropertyDefinition(name, name, propertyType, cardinality, Updatability.READWRITE, false, false, true);
            if (type.getPropertyDefinitions().containsKey(pd.getId())) {
                throw new RuntimeException("Property already defined for name: " + name + " in type: " + type.getId());
            }
            type.addPropertyDefinition(pd);
        }
    }

    protected static AbstractTypeDefinition constructBase(String id, String parentId, boolean isFolder, DocumentType documentType, String nuxeoTypeId, boolean creatable) {
        FolderTypeDefinitionImpl t;
        if (isFolder) {
            t = new FolderTypeDefinitionImpl();
            t.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        } else {
            t = new DocumentTypeDefinitionImpl();
            t.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        }
        t.setId(id);
        t.setParentTypeId(parentId);
        t.setDescription(id);
        t.setDisplayName(id);
        t.setLocalName(nuxeoTypeId == null ? id : nuxeoTypeId);
        Namespace ns = documentType == null ? null : documentType.getNamespace();
        t.setLocalNamespace(ns == null ? NAMESPACE : ns.uri);
        t.setQueryName(id);
        t.setIsCreatable(Boolean.valueOf(creatable));
        t.setIsFileable(Boolean.TRUE);
        t.setIsQueryable(Boolean.TRUE);
        t.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        t.setIsFulltextIndexed(Boolean.TRUE);
        t.setIsControllableAcl(Boolean.FALSE);
        t.setIsControllablePolicy(Boolean.FALSE);
        NuxeoTypeHelper.addBasePropertyDefinitions((AbstractTypeDefinition)t);
        if (t instanceof FolderTypeDefinitionImpl) {
            FolderTypeDefinitionImpl ft = t;
            NuxeoTypeHelper.addFolderPropertyDefinitions(ft);
        } else {
            DocumentTypeDefinitionImpl dt = (DocumentTypeDefinitionImpl)t;
            dt.setIsVersionable(Boolean.FALSE);
            ContentStreamAllowed csa = documentType != null && NuxeoTypeHelper.supportsBlobHolder(documentType) ? ContentStreamAllowed.ALLOWED : ContentStreamAllowed.NOTALLOWED;
            dt.setContentStreamAllowed(csa);
            NuxeoTypeHelper.addDocumentPropertyDefinitions(dt);
        }
        return t;
    }

    protected static void addBasePropertyDefinitions(AbstractTypeDefinition t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:objectId", "Object ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:objectTypeId", "Type ID", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:baseTypeId", "Base Type ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:createdBy", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:creationDate", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:lastModifiedBy", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:lastModificationDate", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:changeToken", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
    }

    protected static void addFolderPropertyDefinitions(FolderTypeDefinitionImpl t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:parentId", "Parent ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type IDs", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, false, false, false));
    }

    protected static void addDocumentPropertyDefinitions(DocumentTypeDefinitionImpl t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isImmutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isLatestVersion", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isMajorVersion", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isLatestMajorVersion", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionLabel", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesId", "Version Series ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isVersionSeriesCheckedOut", "Is Version Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, true, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesCheckedOutId", "Version Series Checked Out ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:checkinComment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamLength", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamMimeType", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamFileName", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamId", "Content Stream ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false));
    }

    protected static PropertyDefinition<?> newPropertyDefinition(String id, String displayName, PropertyType propertyType, Cardinality cardinality, Updatability updatability, boolean inherited, boolean required, boolean queryable) {
        PropertyBooleanDefinitionImpl p;
        switch (propertyType) {
            case BOOLEAN: {
                p = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                p = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                p = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                p = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                p = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                p = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                p = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                p = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException(propertyType.toString());
            }
        }
        p.setId(id);
        p.setDescription(displayName);
        p.setDisplayName(displayName);
        p.setLocalName(id);
        p.setLocalNamespace(null);
        p.setQueryName(id);
        p.setPropertyType(propertyType);
        p.setCardinality(cardinality);
        p.setUpdatability(updatability);
        p.setIsInherited(Boolean.valueOf(inherited));
        p.setIsRequired(Boolean.valueOf(required));
        p.setIsQueryable(Boolean.valueOf(queryable));
        return p;
    }

    protected static boolean supportsBlobHolder(DocumentType documentType) {
        DocumentModelImpl doc = new DocumentModelImpl(null, documentType.getName(), null, new Path("/"), null, null, null, documentType.getSchemaNames(), documentType.getFacets(), null, "default");
        return doc.getAdapter(BlobHolder.class) != null;
    }

    protected static String mappedId(String id) {
        return id;
    }

    protected static PropertyType getPropertType(SimpleType type) {
        SimpleType primitive = type.getPrimitiveType();
        if (primitive == StringType.INSTANCE) {
            return PropertyType.STRING;
        }
        if (primitive == BooleanType.INSTANCE) {
            return PropertyType.BOOLEAN;
        }
        if (primitive == DateType.INSTANCE) {
            return PropertyType.DATETIME;
        }
        if (primitive == LongType.INSTANCE) {
            return PropertyType.INTEGER;
        }
        if (primitive == DoubleType.INSTANCE) {
            return PropertyType.DECIMAL;
        }
        return PropertyType.STRING;
    }
}

