/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoPrincipalImpl
implements NuxeoPrincipal {
    @Deprecated
    public static final String USERNAME_COLUMN = "username";
    @Deprecated
    public static final String FIRSTNAME_COLUMN = "firstName";
    @Deprecated
    public static final String LASTNAME_COLUMN = "lastName";
    @Deprecated
    public static final String COMPANY_COLUMN = "company";
    @Deprecated
    public static final String PASSWORD_COLUMN = "password";
    @Deprecated
    public static final String EMAIL_COLUMN = "email";
    @Deprecated
    public static final String GROUPS_COLUMN = "groups";
    @Deprecated
    private static final String SCHEMA_NAME = "user";
    private static final long serialVersionUID = 1791676740406045594L;
    private static final Log log = LogFactory.getLog(NuxeoPrincipalImpl.class);
    public final List<String> roles = new LinkedList<String>();
    public List<String> virtualGroups = new LinkedList<String>();
    public List<String> allGroups;
    public final boolean isAnonymous;
    public boolean isAdministrator;
    public String principalId;
    public DocumentModel model;
    public DataModel dataModel;
    public String origUserName;

    public NuxeoPrincipalImpl(String name) throws ClientException {
        this(name, false, false);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous) throws ClientException {
        this(name, isAnonymous, false);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous, boolean isAdministrator) throws ClientException {
        this(name, isAnonymous, isAdministrator, true);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous, boolean isAdministrator, boolean updateAllGroups) throws ClientException {
        DocumentModelImpl documentModelImpl = new DocumentModelImpl(SCHEMA_NAME);
        documentModelImpl.addDataModel((DataModel)new DataModelImpl(SCHEMA_NAME, new HashMap()));
        this.setModel((DocumentModel)documentModelImpl, updateAllGroups);
        this.dataModel.setData(USERNAME_COLUMN, (Object)name);
        this.isAnonymous = isAnonymous;
        this.isAdministrator = isAdministrator;
    }

    public String getCompany() {
        try {
            return (String)this.dataModel.getData(COMPANY_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setCompany(String company) {
        try {
            this.dataModel.setData(COMPANY_COLUMN, (Object)company);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getFirstName() {
        try {
            return (String)this.dataModel.getData(FIRSTNAME_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setFirstName(String firstName) {
        try {
            this.dataModel.setData(FIRSTNAME_COLUMN, (Object)firstName);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getLastName() {
        try {
            return (String)this.dataModel.getData(LASTNAME_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setLastName(String lastName) {
        try {
            this.dataModel.setData(LASTNAME_COLUMN, (Object)lastName);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setName(String name) {
        try {
            this.dataModel.setData(USERNAME_COLUMN, (Object)name);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setRoles(List<String> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public void setGroups(List<String> groups) {
        if (this.virtualGroups != null && !this.virtualGroups.isEmpty()) {
            ArrayList<String> groupsToWrite = new ArrayList<String>();
            for (String group : groups) {
                if (this.virtualGroups.contains(group)) continue;
                groupsToWrite.add(group);
            }
            try {
                this.dataModel.setData(GROUPS_COLUMN, groupsToWrite);
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        try {
            this.dataModel.setData(GROUPS_COLUMN, groups);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getName() {
        try {
            return (String)this.dataModel.getData(USERNAME_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public List<String> getGroups() {
        List storedGroups;
        LinkedList<String> groups = new LinkedList<String>();
        try {
            storedGroups = (List)this.dataModel.getData(GROUPS_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
        if (storedGroups != null) {
            groups.addAll(storedGroups);
        }
        groups.addAll(this.virtualGroups);
        return groups;
    }

    @Deprecated
    public List<String> getRoles() {
        return this.roles;
    }

    public void setPassword(String password) {
        try {
            this.dataModel.setData(PASSWORD_COLUMN, (Object)password);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getPassword() {
        return null;
    }

    public String toString() {
        try {
            return (String)this.dataModel.getData(USERNAME_COLUMN);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getEmail() {
        try {
            return (String)this.dataModel.getData(EMAIL_COLUMN);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setEmail(String email) {
        try {
            this.dataModel.setData(EMAIL_COLUMN, (Object)email);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public void setModel(DocumentModel model, boolean updateAllGroups) throws ClientException {
        this.model = model;
        this.dataModel = (DataModel)model.getDataModels().values().iterator().next();
        if (updateAllGroups) {
            this.updateAllGroups();
        }
    }

    public void setModel(DocumentModel model) throws ClientException {
        this.setModel(model, true);
    }

    public boolean isMemberOf(String group) {
        return this.allGroups.contains(group);
    }

    public List<String> getAllGroups() {
        return this.allGroups;
    }

    public void updateAllGroups() throws ClientException {
        UserManager userManager;
        try {
            userManager = (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        HashSet<String> checkedGroups = new HashSet<String>();
        ArrayList<String> groupsToProcess = new ArrayList<String>();
        ArrayList<String> resultingGroups = new ArrayList<String>();
        groupsToProcess.addAll(this.getGroups());
        while (!groupsToProcess.isEmpty()) {
            String groupName = (String)groupsToProcess.remove(0);
            if (checkedGroups.contains(groupName)) continue;
            checkedGroups.add(groupName);
            NuxeoGroup nxGroup = null;
            if (userManager != null) {
                nxGroup = userManager.getGroup(groupName);
            }
            if (nxGroup == null) {
                if (this.virtualGroups.contains(groupName)) {
                    resultingGroups.add(groupName);
                    continue;
                }
                if (userManager == null) continue;
                log.error((Object)("User " + this.getName() + " references the " + groupName + " group that does not exists"));
                continue;
            }
            groupsToProcess.addAll(nxGroup.getParentGroups());
            resultingGroups.add(groupName);
        }
        this.allGroups = new ArrayList<String>(resultingGroups);
        if (!this.isAdministrator() && userManager != null) {
            List<String> adminGroups = userManager.getAdministratorsGroups();
            for (String adminGroup : adminGroups) {
                if (!this.allGroups.contains(adminGroup)) continue;
                this.isAdministrator = true;
                break;
            }
        }
    }

    public List<String> getVirtualGroups() {
        return this.virtualGroups;
    }

    public void setVirtualGroups(List<String> virtualGroups, boolean updateAllGroups) throws ClientException {
        this.virtualGroups = new ArrayList<String>(virtualGroups);
        if (updateAllGroups) {
            this.updateAllGroups();
        }
    }

    public void setVirtualGroups(List<String> virtualGroups) throws ClientException {
        this.setVirtualGroups(virtualGroups, true);
    }

    public boolean isAdministrator() {
        return this.isAdministrator || "system".equals(this.getName());
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean equals(Object other) {
        if (other instanceof Principal) {
            String name = this.getName();
            String otherName = ((Principal)other).getName();
            if (name == null) {
                return otherName == null;
            }
            return name.equals(otherName);
        }
        return false;
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }

    public String getOriginatingUser() {
        return this.origUserName;
    }

    public void setOriginatingUser(String originatingUser) {
        this.origUserName = originatingUser;
    }
}

