/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.Writer;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.ResourceTemplateLoader;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.extensions.BlockDirective;
import org.nuxeo.ecm.platform.rendering.fm.extensions.BlockWriter;
import org.nuxeo.ecm.platform.rendering.fm.extensions.BlockWriterRegistry;
import org.nuxeo.ecm.platform.rendering.fm.extensions.DocRefMethod;
import org.nuxeo.ecm.platform.rendering.fm.extensions.ExtendsDirective;
import org.nuxeo.ecm.platform.rendering.fm.extensions.FormatDate;
import org.nuxeo.ecm.platform.rendering.fm.extensions.LocaleMessagesMethod;
import org.nuxeo.ecm.platform.rendering.fm.extensions.MessagesMethod;
import org.nuxeo.ecm.platform.rendering.fm.extensions.NewMethod;
import org.nuxeo.ecm.platform.rendering.fm.extensions.SuperBlockDirective;
import org.nuxeo.ecm.platform.rendering.fm.i18n.ResourceComposite;

public class FreemarkerEngine
implements RenderingEngine {
    private static final Log log = LogFactory.getLog(FreemarkerEngine.class);
    public static final String RENDERING_ENGINE_KEY = "NX_RENDERING_ENGINE";
    protected final Configuration cfg;
    protected final DocumentObjectWrapper wrapper;
    protected final MessagesMethod messages = new MessagesMethod(null);
    protected final LocaleMessagesMethod localeMessages = new LocaleMessagesMethod(null);
    protected ResourceTemplateLoader loader;

    public FreemarkerEngine() {
        this(null, null);
    }

    public FreemarkerEngine(Configuration cfg, ResourceLocator locator) {
        this.wrapper = new DocumentObjectWrapper(this);
        this.cfg = cfg == null ? new Configuration() : cfg;
        this.cfg.setWhitespaceStripping(true);
        this.cfg.setLocalizedLookup(false);
        this.cfg.setClassicCompatible(true);
        this.cfg.setObjectWrapper((ObjectWrapper)this.wrapper);
        this.cfg.setSharedVariable("block", (TemplateModel)new BlockDirective());
        this.cfg.setSharedVariable("superBlock", (TemplateModel)new SuperBlockDirective());
        this.cfg.setSharedVariable("extends", (TemplateModel)new ExtendsDirective());
        this.cfg.setSharedVariable("docRef", (TemplateModel)new DocRefMethod());
        this.cfg.setSharedVariable("new", (TemplateModel)new NewMethod());
        this.cfg.setSharedVariable("message", (TemplateModel)this.messages);
        this.cfg.setSharedVariable("lmessage", (TemplateModel)this.localeMessages);
        this.cfg.setSharedVariable("formatDate", (TemplateModel)new FormatDate());
        this.cfg.setCustomAttribute(RENDERING_ENGINE_KEY, (Object)this);
        this.setResourceLocator(locator);
    }

    @Override
    public void setMessageBundle(ResourceBundle messages) {
        this.messages.setBundle(messages);
        if (messages instanceof ResourceComposite) {
            this.localeMessages.setBundle((ResourceComposite)messages);
        }
    }

    @Override
    public ResourceBundle getMessageBundle() {
        return this.messages.getBundle();
    }

    @Override
    public void setResourceLocator(ResourceLocator locator) {
        this.loader = new ResourceTemplateLoader(locator);
        this.cfg.setTemplateLoader((TemplateLoader)this.loader);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.loader.getLocator();
    }

    public ResourceTemplateLoader getLoader() {
        return this.loader;
    }

    @Override
    public void setSharedVariable(String key, Object value) {
        try {
            this.cfg.setSharedVariable(key, value);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public DocumentObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    @Override
    public void render(String template, Object input, Writer writer) throws RenderingException {
        try {
            if (template.startsWith("/")) {
                template = "fs://" + template;
            }
            Template temp = this.cfg.getTemplate(template);
            BlockWriter bw = new BlockWriter(temp.getName(), "", new BlockWriterRegistry());
            Environment env = temp.createProcessingEnvironment(input, (Writer)bw, (ObjectWrapper)this.wrapper);
            env.process();
            bw.copyTo(writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }
}

