/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.template;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.rendering.template.DocumentFieldAccessor;
import org.nuxeo.ecm.platform.rendering.template.DocumentValueExporter;

public class DocumentModelAdapter
implements TemplateHashModelEx,
AdapterTemplateModel {
    protected final DocumentModel doc;
    protected final ObjectWrapper wrapper;
    private TemplateCollectionModel keys;
    private int size = -1;

    public DocumentModelAdapter(DocumentModel doc, ObjectWrapper wrapper) {
        this.doc = doc;
        this.wrapper = wrapper;
    }

    public DocumentModelAdapter(DocumentModel doc) {
        this(doc, ObjectWrapper.DEFAULT_WRAPPER);
    }

    public Object getAdaptedObject(Class hint) {
        return this.doc;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        DocumentPart part;
        DocumentFieldAccessor accessor = DocumentFieldAccessor.get(key);
        if (accessor != null) {
            return this.wrapper.wrap(accessor.getValue(this.doc));
        }
        try {
            part = this.doc.getPart(key);
        }
        catch (ClientException e1) {
            throw new TemplateModelException((Exception)((Object)e1));
        }
        if (part != null) {
            try {
                DocumentValueExporter exporter = new DocumentValueExporter();
                Map<String, Serializable> map = exporter.run(part);
                return this.wrapper.wrap(map);
            }
            catch (PropertyException e) {
                throw new TemplateModelException("Failed to get value for schema root property: " + key, (Exception)((Object)e));
            }
        }
        return this.wrapper.wrap(null);
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        if (this.keys == null) {
            ArrayList<String> keysCol = new ArrayList<String>();
            keysCol.addAll(DocumentFieldAccessor.getFieldNames());
            String[] schemas = this.doc.getDeclaredSchemas();
            keysCol.addAll(Arrays.asList(schemas));
            this.size = keysCol.size();
            this.keys = (TemplateCollectionModel)this.wrapper.wrap(keysCol);
        }
        return this.keys;
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (DocumentFieldAccessor accessor : DocumentFieldAccessor.getAcessors()) {
            values.add(accessor.getValue(this.doc));
        }
        try {
            for (DocumentPart part : this.doc.getParts()) {
                values.add(part.getValue());
            }
        }
        catch (PropertyException e) {
            throw new TemplateModelException("failed to fetch a document", (Exception)((Object)e));
        }
        catch (ClientException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        return (TemplateCollectionModel)this.wrapper.wrap(values);
    }

    public int size() throws TemplateModelException {
        if (this.size == -1) {
            this.size = DocumentFieldAccessor.getAcessorsCount() + this.doc.getDeclaredSchemas().length;
        }
        return this.size;
    }
}

